/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.model;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.modelImport.model.Symbol;
import org.simantics.sysdyn.modelImport.model.WriteContext;
import org.simantics.sysdyn.modelImport.model.expression.Expression;
import org.simantics.sysdyn.modelImport.model.support.Range;

public abstract class Variable
extends Symbol {
    private String name;
    private Expression expression;
    private Range range;
    private String unit;
    private String description;
    private Resource variable;

    public Variable() {
    }

    public Variable(String name, Expression expression, Range range, String unit, String description) {
        this.name = name;
        this.expression = expression;
        this.range = range;
        this.unit = unit;
        this.description = description;
    }

    public Variable(double[] dim, String name, Expression expression, Range range, String unit, String description) {
        super(dim);
        this.name = name;
        this.expression = expression;
        this.range = range;
        this.unit = unit;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public Range getRange() {
        return this.range;
    }

    public void setRange(Range range) {
        this.range = range;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Resource write(WriteGraph graph, Resource parent, WriteContext context) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        this.variable = GraphUtils.create2((WriteGraph)graph, (Resource)this.getVariableType((ReadGraph)graph), (Object[])new Object[]{l0.HasName, this.name, l0.PartOf, parent});
        graph.claim(this.variable, mr.Mapped, this.variable);
        if (this.expression != null) {
            this.expression.write(graph, this.variable, context);
        }
        if (this.range != null) {
            this.range.write(graph, this.variable, context);
        }
        if (this.unit != null && !this.unit.isEmpty()) {
            graph.claimLiteral(this.variable, sr.Variable_unit, (Object)this.unit, (Binding)Bindings.STRING);
        }
        if (this.description != null && !this.description.isEmpty()) {
            graph.claimLiteral(this.variable, l0.HasDescription, (Object)this.description, (Binding)Bindings.STRING);
        }
        Resource symbol = super.write(graph, parent, context);
        graph.claim(symbol, mr.ElementToComponent, this.variable);
        return this.variable;
    }

    public abstract Resource getVariableType(ReadGraph var1);

    @Override
    public Resource getResource() {
        return this.variable;
    }
}

