/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.modelImport.mdl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.sysdyn.modelImport.mdl.Declaration;
import org.simantics.sysdyn.modelImport.mdl.MdlModel;
import org.simantics.sysdyn.modelImport.model.support.Function;

public class Lookup
extends Declaration {
    private static final String LOOKUP_RANGE = "\\[\\(([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)),([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?))\\)-\\(([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)),([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?))\\)\\]";
    private static final String LOOKUP_POINTS = "(\\([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?),[+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)\\)(?:,\\([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?),[+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)\\))*)";
    private static final String LOOKUP = "([A-Za-z]\\w*(?:\\s+\\w+)*)\\s*\\(\\s*\\[\\(([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)),([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?))\\)-\\(([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)),([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?))\\)\\],(\\([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?),[+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)\\)(?:,\\([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?),[+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)\\))*)\\s*\\)";
    private static final String LOOKUP_DECL = "([A-Za-z]\\w*(?:\\s+\\w+)*)\\s*\\(\\s*\\[\\(([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)),([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?))\\)-\\(([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)),([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?))\\)\\],(\\([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?),[+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)\\)(?:,\\([+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?),[+-]?(?:NaN|Infinity|\\d+(?:\\.\\d+)?(?:[eE][+-]?\\d+)?)\\))*)\\s*\\)(\\s*~\\s*([^~]*?)\\s*~\\s*([^\\|]*?)\\s*\\|)";
    private static final int lookupName = 1;
    private static final int lookupRangeXMin = 2;
    private static final int lookupRangeYMin = 3;
    private static final int lookupRangeXMax = 4;
    private static final int lookupRangeYMax = 5;
    private static final int lookupPoints = 6;
    private static final int lookupSuffix = 7;
    private double xMin;
    private double yMin;
    private double xMax;
    private double yMax;
    private double[] points;
    private Function function;

    protected Lookup(String name, MdlModel mdl, double xMin, double yMin, double xMax, double yMax, double[] points) {
        super(name, mdl);
        this.xMin = xMin;
        this.yMin = yMin;
        this.xMax = xMax;
        this.yMax = yMax;
        this.points = points;
    }

    public static Lookup getPossible(String line, MdlModel mdl) throws Exception {
        Matcher matcher = Pattern.compile(LOOKUP_DECL).matcher(line);
        if (!matcher.matches()) {
            return null;
        }
        String name = matcher.group(1).toUpperCase();
        double xMin = Double.parseDouble(matcher.group(2));
        double yMin = Double.parseDouble(matcher.group(3));
        double xMax = Double.parseDouble(matcher.group(4));
        double yMax = Double.parseDouble(matcher.group(5));
        double[] points = Lookup.parsePoints(matcher.group(6));
        Lookup lookup = new Lookup(name, mdl, xMin, yMin, xMax, yMax, points);
        lookup.parseSuffix(matcher.group(7));
        return lookup;
    }

    private static double[] parsePoints(String str) {
        str = str.replaceFirst("[(),]+", "");
        String[] parts = str.split("[(),]+");
        double[] points = new double[parts.length];
        int i = 0;
        while (i < parts.length) {
            points[i] = Double.parseDouble(parts[i]);
            ++i;
        }
        return points;
    }

    public double getxMin() {
        return this.xMin;
    }

    public double getyMin() {
        return this.yMin;
    }

    public double getxMax() {
        return this.xMax;
    }

    public double getyMax() {
        return this.yMax;
    }

    public double[] getPoints() {
        return this.points;
    }

    public Function getFunction() {
        if (this.function != null) {
            return this.function;
        }
        StringBuilder body = new StringBuilder();
        body.append("input Real i;\n");
        body.append("output Real o;\n");
        body.append("algorithm\n");
        body.append("o := interpolate(i, {");
        int i = 0;
        while (i < this.points.length / 2) {
            if (i > 0) {
                body.append(',');
            }
            body.append('{').append(this.points[2 * i]).append(',').append(this.points[2 * i + 1]).append('}');
            ++i;
        }
        body.append("});\n");
        this.function = new Function(this.getName().replaceAll("\\s+", ""), body.toString());
        return this.function;
    }
}

