/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.OldSysdynExperiment;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.solver.ISolverMonitor;

public class SysdynPlaybackExperiment
extends OldSysdynExperiment {
    public static long DURATION_SLOW = 20000L;
    public static long DURATION_NORMAL = 10000L;
    public static long DURATION_FAST = 5000L;
    double time = 0.0;
    double startTime;
    double endTime;
    public static final long VARIABLE_UPDATE_INTERVAL = 500000000L;
    private static final double UPDATES_PER_TIME_UNIT = 0.015;
    private long playbackDuration = DURATION_NORMAL;
    private Collection<Runnable> timeListeners = new ArrayList<Runnable>();
    ScheduledExecutorService playbackExecutionService;
    PlaybackConfiguration playbackConfiguration;

    public SysdynPlaybackExperiment(Resource experiment, Resource model, String identifier) {
        super(experiment, model, identifier);
    }

    public void setTimeInterrupting(double time) {
        this.stopPlayback();
        this.setTime(time);
    }

    public void setTimeAndContinue(double time) {
        if (this.isPlaybackRunning()) {
            this.stopPlayback();
            this.setTime(time);
            this.startPlayback(500L);
        } else {
            this.setTime(time);
        }
    }

    private void setTime(double time) {
        this.time = time;
        this.resultsChanged();
    }

    public double getTime() {
        return this.time;
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public void setPlaybackDuration(long duration) {
        this.playbackDuration = duration;
        if (this.isPlaybackRunning()) {
            this.startPlayback();
        }
    }

    public long getPlaybackDuration() {
        return this.playbackDuration;
    }

    @Override
    public void init(ReadGraph g) {
        this.session = g.getSession();
        this.session.asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                SysdynPlaybackExperiment.this.changeState(ExperimentState.RUNNING);
                Resource configuration = graph.getPossibleObject(SysdynPlaybackExperiment.this.model, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration);
                SysdynPlaybackExperiment.this.sysdynModel = SysdynModelManager.getInstance(SysdynPlaybackExperiment.this.session).getModel(graph, configuration);
                SysdynPlaybackExperiment.this.toggleActivation(graph, true);
                SysdynPlaybackExperiment.this.getPlaybackConfiguration(graph);
                SysdynPlaybackExperiment.this.startSimulationJob();
            }
        });
    }

    public void startPlayback() {
        this.startPlayback(0L);
    }

    public void startPlayback(long initialDelay) {
        if (this.isPlaybackRunning()) {
            this.stopPlayback();
        }
        this.playbackConfiguration = this.getPlaybackConfiguration();
        this.playbackExecutionService = Executors.newScheduledThreadPool(1);
        if (this.time >= this.playbackConfiguration.endTime) {
            this.setTime(this.playbackConfiguration.startTime);
            this.playbackConfiguration = this.getPlaybackConfiguration();
        }
        PlaybackSimulationTask playbackSimulationTask = new PlaybackSimulationTask(this.time, this.playbackConfiguration.simulationStepLength);
        long delay = (long)((double)this.playbackConfiguration.playbackDuration / this.playbackConfiguration.intervals);
        ScheduledFuture<?> stepper = this.playbackExecutionService.scheduleWithFixedDelay(playbackSimulationTask, initialDelay, delay, TimeUnit.MILLISECONDS);
        StopSimulationTask stopSimulationTask = new StopSimulationTask(stepper, this.playbackConfiguration.endTime);
        this.playbackExecutionService.schedule(stopSimulationTask, this.playbackConfiguration.playbackDuration + initialDelay, TimeUnit.MILLISECONDS);
        this.changeState(ExperimentState.RUNNING);
    }

    public boolean isPlaybackRunning() {
        return this.playbackExecutionService != null && !this.playbackExecutionService.isShutdown();
    }

    public void resetPlayback() {
        double startTime = 0.0;
        startTime = this.isPlaybackRunning() && this.playbackConfiguration != null ? this.playbackConfiguration.startTime : this.getPlaybackConfiguration().startTime;
        this.setTimeInterrupting(startTime);
    }

    public void stopPlayback() {
        if (this.isPlaybackRunning()) {
            this.playbackExecutionService.shutdownNow();
            this.playbackExecutionService.shutdown();
            if (this.playbackConfiguration != null) {
                this.playbackConfiguration = null;
            }
            this.changeState(ExperimentState.STOPPED);
        }
    }

    private PlaybackConfiguration getPlaybackConfiguration() {
        PlaybackConfiguration config = null;
        try {
            config = (PlaybackConfiguration)Simantics.getSession().syncRequest((Read)new Read<PlaybackConfiguration>(){

                public PlaybackConfiguration perform(ReadGraph graph) throws DatabaseException {
                    return SysdynPlaybackExperiment.this.getPlaybackConfiguration(graph);
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return config;
    }

    private PlaybackConfiguration getPlaybackConfiguration(ReadGraph graph) throws DatabaseException {
        Double[] numbers = new Double[3];
        Resource model = this.getModel();
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        numbers[0] = (Double)graph.getRelatedValue(model, sr.SysdynModel_startTime);
        numbers[1] = (Double)graph.getRelatedValue(model, sr.SysdynModel_stopTime);
        PlaybackConfiguration config = new PlaybackConfiguration();
        config.simulationDuration = numbers[1] - numbers[0] - this.time;
        config.playbackDuration = (long)(config.simulationDuration / (config.simulationDuration + this.time) * (double)this.playbackDuration);
        config.intervals = (double)config.playbackDuration * 0.015;
        config.simulationStepLength = config.simulationDuration / config.intervals;
        config.endTime = numbers[1];
        this.startTime = config.startTime = numbers[0].doubleValue();
        this.endTime = config.endTime;
        return config;
    }

    @Override
    protected void localStateChange() {
        super.localStateChange();
        ExperimentState state = this.getState();
        if (ExperimentState.DISPOSED.equals((Object)state)) {
            this.stopPlayback();
        }
    }

    public void addTimeListener(Runnable timeListener) {
        if (!this.timeListeners.contains(timeListener)) {
            this.timeListeners.add(timeListener);
        }
    }

    public Collection<Runnable> getTimeListeners() {
        return this.timeListeners;
    }

    public void removeTimeListener(Runnable timeListener) {
        this.timeListeners.remove(timeListener);
    }

    @Override
    public void resultsChanged() {
        for (Runnable listener : this.timeListeners) {
            listener.run();
        }
        super.resultsChanged();
    }

    @Override
    public void createSolver(ISolverMonitor solverMonitor) {
    }

    private class PlaybackConfiguration {
        public double simulationDuration;
        public double simulationStepLength;
        public double intervals;
        public double endTime;
        public double startTime;
        public long playbackDuration;

        private PlaybackConfiguration() {
        }
    }

    private class PlaybackSimulationTask
    implements Runnable {
        private int stepCount;
        private double startTime;
        private double stepLength;

        public PlaybackSimulationTask(double startTime, double stepLength) {
            this.startTime = startTime;
            this.stepLength = stepLength;
        }

        @Override
        public void run() {
            ++this.stepCount;
            SysdynPlaybackExperiment.this.setTime(this.startTime + (double)this.stepCount * this.stepLength);
        }
    }

    private class StopSimulationTask
    implements Runnable {
        private ScheduledFuture<?> scheduledFuture;
        private double endTime;

        public StopSimulationTask(ScheduledFuture<?> aSchedFuture, double endTime) {
            this.scheduledFuture = aSchedFuture;
            this.endTime = endTime;
        }

        @Override
        public void run() {
            this.scheduledFuture.cancel(false);
            SysdynPlaybackExperiment.this.stopPlayback();
            SysdynPlaybackExperiment.this.setTime(this.endTime);
        }
    }
}

