/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import gnu.trove.list.array.TDoubleArrayList;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Write;
import org.simantics.modelica.IModelicaMonitor;
import org.simantics.modeling.PartialIC;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.GameResult;
import org.simantics.sysdyn.manager.MemoryResult;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.solver.ISolver;
import org.simantics.sysdyn.solver.ISolverMonitor;
import org.simantics.sysdyn.solver.InternalSolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysdynGameExperimentInternal
extends SysdynGameExperimentBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SysdynGameExperimentInternal.class);

    public SysdynGameExperimentInternal(Resource experiment, Resource model, String identifier) {
        super(experiment, model, identifier);
    }

    @Override
    public ISolver getSolver() {
        return this.solver;
    }

    @Override
    public void createSolver(ISolverMonitor solverMonitor) {
        this.solver = new InternalSolver(this, this.sysdynModel, true);
    }

    @Override
    public void simulate(boolean enabled) {
        super.simulate(enabled);
    }

    @Override
    public synchronized void simulate(IModelicaMonitor monitor, IProgressMonitor progressMonitor, String modelName_) throws IOException {
        this.reset();
    }

    public synchronized void reset() {
        try {
            this.ensureSolver();
            this.solver.initialize();
            this.solver.setStepLength(this.stepLength);
            this.solver.buildModel();
            this.subscription = ((InternalSolver)this.solver).solver.keys();
            if (this.subscriptionIndexes == null) {
                this.subscriptionIndexes = new HashMap();
            }
            this.subscriptionIndexes.clear();
            int i = 0;
            while (i < this.subscription.length) {
                this.subscriptionIndexes.put(this.subscription[i], i);
                ++i;
            }
            this.currentValues = new double[this.subscription.length];
            this.results = new TDoubleArrayList[this.currentValues.length];
            this.clearResults();
            Simantics.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Variable base = Variables.getVariable((ReadGraph)graph, (Resource)SysdynGameExperimentInternal.this.experiment);
                    SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
                    Resource ic = graph.getPossibleObject(SysdynGameExperimentInternal.this.experiment, SYSDYN.Experiment_ic);
                    if (ic == null) {
                        return;
                    }
                    PartialIC data = (PartialIC)graph.getPossibleRelatedValue(ic, SYSDYN.InitialCondition_HasInitialValues, PartialIC.BINDING);
                    data.apply(graph, base);
                }
            });
            this.setSubscribedResults((IProgressMonitor)new NullProgressMonitor(), this.solver.getTime());
            ((MemoryResult)this.getCurrentResult()).setResult(new GameResult(this, this.results, this.subscription));
            this.resultsChanged(true);
            this.changeState(ExperimentState.STOPPED);
        }
        catch (Exception e) {
            LOGGER.error("Error while setting up game experiment", (Throwable)e);
        }
    }

    @Override
    public void refresh() {
        try {
            if (this.publishResults) {
                this.setSubscribedResults((IProgressMonitor)new NullProgressMonitor(), this.solver.getTime());
                ((MemoryResult)this.getCurrentResult()).setResult(new GameResult(this, this.results, this.subscription));
            }
            this.resultsChanged(true);
        }
        catch (Exception e) {
            LOGGER.error("Error while refreshing game experiment", (Throwable)e);
        }
    }

    @Override
    public void rewindTo(double time) {
        if (time > -0.001 && time < 0.001) {
            this.solver = null;
            this.reset();
        } else {
            LOGGER.info("rewindTo");
        }
    }
}

