/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.sysdyn.SysdynResource;

public class ActiveResults
implements Read<Collection<Resource>> {
    private Resource resource;

    public ActiveResults(Resource resource) {
        this.resource = resource;
    }

    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
        Collection<Object> experiments;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        ModelingResources MR = ModelingResources.getInstance((ReadGraph)graph);
        ArrayList<Resource> result = new ArrayList<Resource>();
        if (graph.isInstanceOf(this.resource, MR.StructuralModel)) {
            experiments = (Collection)graph.syncRequest((Read)new ObjectsWithType(this.resource, L0.ConsistsOf, SR.Experiment));
        } else {
            experiments = new ArrayList<Resource>();
            experiments.add(this.resource);
        }
        for (Resource experiment : experiments) {
            Collection experimentResults = graph.getObjects(experiment, SR.Experiment_result);
            for (Resource r : experimentResults) {
                if (!graph.hasStatement(r, SR.Result_showResult)) continue;
                result.add(r);
            }
            Collection experimentResultSets = graph.getObjects(experiment, SR.Experiment_resultSet);
            for (Resource resultSet : experimentResultSets) {
                experimentResults = graph.getObjects(resultSet, SR.Experiment_result);
                for (Resource r : experimentResults) {
                    if (!graph.hasStatement(r, SR.Result_showResult)) continue;
                    result.add(r);
                }
            }
        }
        return result;
    }
}

