/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.elementaryCycles;

import java.util.Vector;
import org.simantics.sysdyn.elementaryCycles.AdjacencyList;
import org.simantics.sysdyn.elementaryCycles.SCCResult;

public class StrongConnectedComponents {
    private int[][] adjListOriginal = null;
    private int[][] adjList = null;
    private boolean[] visited = null;
    private Vector stack = null;
    private int[] lowlink = null;
    private int[] number = null;
    private int sccCounter = 0;
    private Vector currentSCCs = null;

    public StrongConnectedComponents(int[][] adjList) {
        this.adjListOriginal = adjList;
    }

    public SCCResult getAdjacencyList(int node) {
        this.visited = new boolean[this.adjListOriginal.length];
        this.lowlink = new int[this.adjListOriginal.length];
        this.number = new int[this.adjListOriginal.length];
        this.visited = new boolean[this.adjListOriginal.length];
        this.stack = new Vector();
        this.currentSCCs = new Vector();
        this.makeAdjListSubgraph(node);
        int i = node;
        while (i < this.adjListOriginal.length) {
            if (!this.visited[i]) {
                this.getStrongConnectedComponents(i);
                Vector nodes = this.getLowestIdComponent();
                if (nodes != null && !nodes.contains(new Integer(node)) && !nodes.contains(new Integer(node + 1))) {
                    return this.getAdjacencyList(node + 1);
                }
                Vector[] adjacencyList = this.getAdjList(nodes);
                if (adjacencyList != null) {
                    int j = 0;
                    while (j < this.adjListOriginal.length) {
                        if (adjacencyList[j].size() > 0) {
                            return new SCCResult(adjacencyList, j);
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private void makeAdjListSubgraph(int node) {
        this.adjList = new int[this.adjListOriginal.length][0];
        int i = node;
        while (i < this.adjList.length) {
            Vector<Integer> successors = new Vector<Integer>();
            int j = 0;
            while (j < this.adjListOriginal[i].length) {
                if (this.adjListOriginal[i][j] >= node) {
                    successors.add(new Integer(this.adjListOriginal[i][j]));
                }
                ++j;
            }
            if (successors.size() > 0) {
                this.adjList[i] = new int[successors.size()];
                j = 0;
                while (j < successors.size()) {
                    Integer succ = (Integer)successors.get(j);
                    this.adjList[i][j] = succ;
                    ++j;
                }
            }
            ++i;
        }
    }

    private Vector getLowestIdComponent() {
        int min = this.adjList.length;
        Vector currScc = null;
        int i = 0;
        while (i < this.currentSCCs.size()) {
            Vector scc = (Vector)this.currentSCCs.get(i);
            int j = 0;
            while (j < scc.size()) {
                Integer node = (Integer)scc.get(j);
                if (node < min) {
                    currScc = scc;
                    min = node;
                }
                ++j;
            }
            ++i;
        }
        return currScc;
    }

    private Vector[] getAdjList(Vector nodes) {
        Vector[] lowestIdAdjacencyList = null;
        if (nodes != null) {
            lowestIdAdjacencyList = new Vector[this.adjList.length];
            int i = 0;
            while (i < lowestIdAdjacencyList.length) {
                lowestIdAdjacencyList[i] = new Vector();
                ++i;
            }
            i = 0;
            while (i < nodes.size()) {
                int node = (Integer)nodes.get(i);
                int j = 0;
                while (j < this.adjList[node].length) {
                    int succ = this.adjList[node][j];
                    if (nodes.contains(new Integer(succ))) {
                        lowestIdAdjacencyList[node].add(new Integer(succ));
                    }
                    ++j;
                }
                ++i;
            }
        }
        return lowestIdAdjacencyList;
    }

    private void getStrongConnectedComponents(int root) {
        this.lowlink[root] = ++this.sccCounter;
        this.number[root] = this.sccCounter;
        this.visited[root] = true;
        this.stack.add(new Integer(root));
        int i = 0;
        while (i < this.adjList[root].length) {
            int w = this.adjList[root][i];
            if (!this.visited[w]) {
                this.getStrongConnectedComponents(w);
                this.lowlink[root] = Math.min(this.lowlink[root], this.lowlink[w]);
            } else if (this.number[w] < this.number[root] && this.stack.contains(new Integer(w))) {
                this.lowlink[root] = Math.min(this.lowlink[root], this.number[w]);
            }
            ++i;
        }
        if (this.lowlink[root] == this.number[root] && this.stack.size() > 0) {
            int next = -1;
            Vector<Integer> scc = new Vector<Integer>();
            do {
                next = (Integer)this.stack.get(this.stack.size() - 1);
                this.stack.remove(this.stack.size() - 1);
                scc.add(new Integer(next));
            } while (this.number[next] > this.number[root]);
            if (scc.size() > 1) {
                this.currentSCCs.add(scc);
            }
        }
    }

    public static void main(String[] args) {
        boolean[][] adjMatrix = new boolean[10][];
        int i = 0;
        while (i < 10) {
            adjMatrix[i] = new boolean[10];
            ++i;
        }
        adjMatrix[0][1] = true;
        adjMatrix[1][2] = true;
        adjMatrix[2][0] = true;
        adjMatrix[2][6] = true;
        adjMatrix[3][4] = true;
        adjMatrix[4][5] = true;
        adjMatrix[4][6] = true;
        adjMatrix[5][3] = true;
        adjMatrix[6][7] = true;
        adjMatrix[7][8] = true;
        adjMatrix[8][6] = true;
        adjMatrix[6][1] = true;
        int[][] adjList = AdjacencyList.getAdjacencyList(adjMatrix);
        StrongConnectedComponents scc = new StrongConnectedComponents(adjList);
        int i2 = 0;
        while (i2 < adjList.length) {
            System.out.print("i: " + i2 + "\n");
            SCCResult r = scc.getAdjacencyList(i2);
            if (r != null) {
                Vector[] al = scc.getAdjacencyList(i2).getAdjList();
                int j = i2;
                while (j < al.length) {
                    if (al[j].size() > 0) {
                        System.out.print("j: " + j);
                        int k = 0;
                        while (k < al[j].size()) {
                            System.out.print(" _" + al[j].get(k).toString());
                            ++k;
                        }
                        System.out.print("\n");
                    }
                    ++j;
                }
                System.out.print("\n");
            }
            ++i2;
        }
    }
}

