/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadExt;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynDataSet;
import org.simantics.sysdyn.nodemanager.ChildVariableNode;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.EnumerationIndex;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.Redeclaration;
import org.simantics.sysdyn.representation.Variable;

public class VariableRVIUtils {
    private static void traverseIndexes(ReadGraph g, String rvi, HashMap<String, String> rvis, List<Resource> arrayIndexes) throws DatabaseException {
        VariableRVIUtils.traverseIndexes(g, rvi, rvis, arrayIndexes, 0, "", "");
    }

    private static void traverseIndexes(ReadGraph g, String rvi, HashMap<String, String> rvis, List<Resource> arrayIndexes, int currentIndex, String indexesSoFar, String indexNamesSoFar) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
        Resource enumerationIndexes = g.getPossibleObject(arrayIndexes.get(currentIndex), sr.Enumeration_enumerationIndexList);
        if (enumerationIndexes == null) {
            return;
        }
        List indexes = ListUtils.toList((ReadGraph)g, (Resource)enumerationIndexes);
        int i = 0;
        while (i < indexes.size()) {
            Boolean b = (Boolean)g.getPossibleRelatedValue((Resource)indexes.get(i), sr.EnumerationIndex_showEnumerationIndexInCharts, (Binding)Bindings.BOOLEAN);
            if (Boolean.TRUE.equals(b)) {
                String name = (String)g.getRelatedValue((Resource)indexes.get(i), Layer0.getInstance((ReadGraph)g).HasName);
                if (currentIndex < arrayIndexes.size() - 1) {
                    VariableRVIUtils.traverseIndexes(g, rvi, rvis, arrayIndexes, currentIndex + 1, String.valueOf(indexesSoFar) + (i + 1) + ",", String.valueOf(indexNamesSoFar) + name + ",");
                } else {
                    rvis.put(String.valueOf(rvi) + "[" + indexesSoFar + (i + 1) + "]", String.valueOf(rvi) + "[" + indexNamesSoFar + name + "]");
                }
            }
            ++i;
        }
    }

    private static void traverseIndexes2(String rvi, Map<String, Tuple2> rvis, List<Enumeration> arrayIndexes) {
        VariableRVIUtils.traverseIndexes2(rvi, rvis, arrayIndexes, 0, "", "");
    }

    private static void traverseIndexes2(String rvi, Map<String, Tuple2> rvis, List<Enumeration> arrayIndexes, int currentIndex, String indexesSoFar, String indexNamesSoFar) {
        Enumeration e = arrayIndexes.get(currentIndex);
        int pos = 0;
        for (EnumerationIndex i : e.getEnumerationIndexes()) {
            if (i.getShowEnumerationIndexInCharts().booleanValue()) {
                String name = i.getName();
                if (currentIndex < arrayIndexes.size() - 1) {
                    VariableRVIUtils.traverseIndexes2(rvi, rvis, arrayIndexes, currentIndex + 1, String.valueOf(indexesSoFar) + (pos + 1) + ",", String.valueOf(indexNamesSoFar) + name + ",");
                } else {
                    rvis.put(String.valueOf(rvi) + "[" + indexesSoFar + (pos + 1) + "]", new Tuple2((Object)rvis.size(), (Object)(String.valueOf(rvi) + "[" + indexNamesSoFar + name + "]")));
                }
            }
            ++pos;
        }
    }

    private static List<Resource> resolveActiveArrayIndexes(ReadGraph graph, org.simantics.db.layer0.variable.Variable variable, List<Resource> enumerations) {
        try {
            Resource module;
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            String uri = variable.getURI(graph);
            uri = uri.substring(0, uri.lastIndexOf("/"));
            org.simantics.db.layer0.variable.Variable v = Variables.getPossibleVariable((ReadGraph)graph, (String)uri);
            if (v != null && (module = v.getRepresents(graph)) != null && graph.isInheritedFrom(graph.getSingleObject(module, l0.InstanceOf), sr.Module)) {
                boolean somethingIsReplaced = false;
                for (Resource redeclaration : (Collection)graph.syncRequest((Read)new ObjectsWithType(module, sr.Module_redeclaration, sr.Redeclaration))) {
                    Resource replaced = graph.getSingleObject(redeclaration, sr.Redeclaration_replacedEnumeration);
                    while (enumerations.contains(replaced)) {
                        enumerations.add(enumerations.indexOf(replaced), graph.getSingleObject(redeclaration, sr.Redeclaration_replacingEnumeration));
                        enumerations.remove(replaced);
                        somethingIsReplaced = true;
                    }
                }
                if (somethingIsReplaced) {
                    VariableRVIUtils.resolveActiveArrayIndexes(graph, v, enumerations);
                }
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return enumerations;
    }

    private static List<Enumeration> resolveActiveArrayIndexes2(ChildVariableNode node, List<Enumeration> enumerations) {
        ChildVariableNode v = (ChildVariableNode)node.getParent();
        if (v != null && v.getElement() instanceof Module) {
            Module m = (Module)v.getElement();
            boolean somethingIsReplaced = false;
            for (Redeclaration redeclaration : m.getRedeclarations()) {
                Enumeration replaced = redeclaration.getReplacedEnumeration();
                while (enumerations.contains(replaced)) {
                    if (!somethingIsReplaced) {
                        enumerations = new ArrayList<Enumeration>(enumerations);
                    }
                    Enumeration replacing = redeclaration.getReplacingEnumeration();
                    enumerations.add(enumerations.indexOf(replaced), replacing);
                    enumerations.remove(replaced);
                    somethingIsReplaced = true;
                }
            }
            if (somethingIsReplaced) {
                VariableRVIUtils.resolveActiveArrayIndexes2(v, enumerations);
            }
        }
        return enumerations;
    }

    public static Map<String, Tuple2> getActiveRVIs(ChildVariableNode node) {
        Variable v = (Variable)node.getElement();
        if (v == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Tuple2> rvis = new LinkedHashMap<String, Tuple2>();
        String rvi = node.getRVI();
        List<Enumeration> arrayIndexList = v.getArrayIndexes();
        if (arrayIndexList.isEmpty()) {
            rvis.put(rvi, new Tuple2((Object)0, (Object)rvi));
        } else if ((arrayIndexList = VariableRVIUtils.resolveActiveArrayIndexes2(node, arrayIndexList)).size() > 0) {
            VariableRVIUtils.traverseIndexes2(rvi, rvis, arrayIndexList);
        } else {
            rvis.put(rvi, new Tuple2((Object)0, (Object)rvi));
        }
        return rvis;
    }

    public static ArrayList<SysdynDataSet> getDataset(ArrayList<SysdynDataSet> datasets, String[] filter) {
        boolean doFiltering = false;
        String[] stringArray = filter;
        int n = filter.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            if (!f.equalsIgnoreCase("All")) {
                doFiltering = true;
                break;
            }
            ++n2;
        }
        if (!doFiltering) {
            return datasets;
        }
        ArrayList<SysdynDataSet> result = datasets;
        int i = filter.length - 1;
        while (i >= 0) {
            String currentFilter = filter[i].trim();
            ArrayList<SysdynDataSet> tempResult = new ArrayList<SysdynDataSet>();
            THashMap sums = new THashMap();
            for (SysdynDataSet dataset : result) {
                String tempIndexes = dataset.name.substring(dataset.name.indexOf(91) + 1, dataset.name.indexOf(93));
                String[] indexes = tempIndexes.split(",");
                if (currentFilter.equals("All")) {
                    tempResult.add(dataset);
                    continue;
                }
                if (currentFilter.equals(indexes[i].trim())) {
                    tempResult.add(dataset);
                    continue;
                }
                if (!currentFilter.equals("Sum")) continue;
                String rangeBefore = "";
                int j = 0;
                while (j < i) {
                    rangeBefore = String.valueOf(rangeBefore) + indexes[j].trim();
                    ++j;
                }
                SysdynDataSet sum = (SysdynDataSet)((Object)sums.get(rangeBefore));
                if (sum != null) {
                    int j2 = 0;
                    while (j2 < sum.values.length) {
                        sum.values[j2] = sum.values[j2] + dataset.values[j2];
                        ++j2;
                    }
                    continue;
                }
                double[] times = new double[dataset.times.length];
                int j3 = 0;
                while (j3 < dataset.times.length) {
                    times[j3] = dataset.times[j3];
                    ++j3;
                }
                double[] values = new double[dataset.values.length];
                int j4 = 0;
                while (j4 < dataset.values.length) {
                    values[j4] = dataset.values[j4];
                    ++j4;
                }
                SysdynDataSet newDataset = new SysdynDataSet(dataset.name, dataset.result, times, values);
                tempResult.add(newDataset);
                sums.put(rangeBefore, newDataset);
                String name = newDataset.name.substring(0, newDataset.name.indexOf(91) + 1);
                int j5 = 0;
                while (j5 < indexes.length) {
                    if (j5 < i) {
                        name = String.valueOf(name) + indexes[j5].trim();
                    } else if (j5 >= i) {
                        name = String.valueOf(name) + filter[j5].trim();
                    }
                    if (j5 < indexes.length - 1) {
                        name = String.valueOf(name) + ", ";
                    }
                    ++j5;
                }
                newDataset.name = name = String.valueOf(name) + "]";
            }
            result.clear();
            for (SysdynDataSet dataset : tempResult) {
                result.add(dataset);
            }
            --i;
        }
        return result;
    }

    public static class GetActiveRVIs
    extends VariableRead<HashMap<String, String>>
    implements ReadExt {
        public GetActiveRVIs(org.simantics.db.layer0.variable.Variable variable) {
            super(variable);
        }

        public HashMap<String, String> perform(ReadGraph graph) throws DatabaseException {
            LinkedHashMap<String, String> rvis = new LinkedHashMap<String, String>();
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            String rvi = Variables.getRVI((ReadGraph)graph, (org.simantics.db.layer0.variable.Variable)this.variable);
            Resource r = this.variable.getRepresents(graph);
            Resource arrayIndexes = graph.getPossibleObject(r, sr.Variable_arrayIndexesList);
            if (arrayIndexes == null) {
                rvis.put(rvi, rvi);
            } else {
                List arrayIndexList = ListUtils.toList((ReadGraph)graph, (Resource)arrayIndexes);
                VariableRVIUtils.resolveActiveArrayIndexes(graph, this.variable, arrayIndexList);
                if (arrayIndexList.size() > 0) {
                    VariableRVIUtils.traverseIndexes(graph, rvi, rvis, arrayIndexList);
                } else {
                    rvis.put(rvi, rvi);
                }
            }
            return rvis;
        }

        public boolean isImmutable(ReadGraph graph) throws DatabaseException {
            return false;
        }

        public int getType() {
            return 1;
        }
    }
}

