/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter;

import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.sysdyn.adapter.ValueIndexVariableBase;
import org.simantics.sysdyn.nodemanager.SysdynValueData;

public class ValueIndexVariableN
extends ValueIndexVariableBase<Double> {
    final boolean scalar;

    public ValueIndexVariableN(Variable parent, SysdynValueData data, String indexes, boolean scalar) throws DatabaseException {
        super(indexes);
        this.parent = parent;
        this.data = data;
        this.scalar = scalar;
    }

    private double[] values() {
        List<Integer> ls = this.getVariableArrayIndices();
        double[] array = this.data.values;
        double[] result = new double[ls.size()];
        int pos = 0;
        for (Integer i : ls) {
            result[pos++] = array[i];
        }
        return result;
    }

    private Double getValueScalar() {
        double[] array = this.values();
        if (array == null || array.length == 0) {
            return Double.NaN;
        }
        return array[0];
    }

    @Override
    public <U> U getValue(ReadGraph graph) throws DatabaseException {
        if (this.scalar) {
            return (U)this.getValueScalar();
        }
        return (U)this.values();
    }

    @Override
    public <U> U getValue(ReadGraph graph, Binding binding) throws DatabaseException {
        try {
            Binding b = Bindings.getBinding((Datatype)this.getDatatype(graph));
            return (U)Bindings.adapt(this.getValue(graph), (Binding)b, (Binding)binding);
        }
        catch (AdaptException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    @Override
    public void setValue(WriteGraph graph, Object value) throws DatabaseException {
        this.setIndexedValue(graph, value);
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        this.setValue(graph, value);
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        return this.indexes;
    }

    @Override
    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        if (this.scalar) {
            return Datatypes.DOUBLE;
        }
        return Datatypes.DOUBLE_ARRAY;
    }

    @Override
    public Double getValue() {
        throw new IllegalStateException();
    }
}

