/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.wizards.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.wizards.model.SysdynExportModel;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class SysdynModelExportPage
extends WizardPage {
    private SysdynExportModel exportModel;
    private CCombo exportLocation;
    private CCombo model;
    private Text description;
    private Button overwrite;
    private List<NamedResource> models;
    private Button dependencies;
    private Button browseFileButton;

    protected SysdynModelExportPage(SysdynExportModel exportModel) {
        super("Export Sysdyn Model", "Define Export location", null);
        this.exportModel = exportModel;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        new Label(container, 0).setText("Exported model:");
        this.model = new CCombo(container, 2048);
        this.model.setEditable(false);
        this.model.setText("");
        this.model.setToolTipText("Selects the model to export a state from.");
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.model);
        this.model.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                for (NamedResource nr : SysdynModelExportPage.this.models) {
                    if (!SysdynModelExportPage.this.model.getText().equals(nr.getName())) continue;
                    SysdynModelExportPage.this.exportModel.setModel(nr);
                    break;
                }
                SysdynModelExportPage.this.browseFileButton.setFocus();
                SysdynModelExportPage.this.validatePage();
            }
        });
        new Label(container, 0).setText("&Target file:");
        this.exportLocation = new CCombo(container, 2048);
        this.exportLocation.setText("");
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.exportLocation);
        this.exportLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SysdynModelExportPage.this.validatePage();
            }
        });
        this.browseFileButton = new Button(container, 8);
        this.browseFileButton.setText("Brows&e...");
        this.browseFileButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.browseFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(SysdynModelExportPage.this.getShell(), 8192);
                dialog.setText("Choose Export Target File");
                String loc = SysdynModelExportPage.this.exportLocation.getText();
                dialog.setFilterPath(loc);
                dialog.setFilterExtensions(new String[]{"*.sysdyn"});
                dialog.setFilterNames(new String[]{"Sysdyn Model (*.sysdyn)"});
                dialog.setOverwrite(false);
                String file = dialog.open();
                if (file == null) {
                    return;
                }
                SysdynModelExportPage.this.exportLocation.setText(file);
                SysdynModelExportPage.this.validatePage();
            }
        });
        new Label(container, 0).setText("Notes:");
        this.description = new Text(container, 2562);
        GridDataFactory.fillDefaults().hint(-1, 150).grab(true, true).span(3, 1).applyTo((Control)this.description);
        this.description.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SysdynModelExportPage.this.exportModel.setDescription(SysdynModelExportPage.this.description.getText());
            }
        });
        Label horizRule = new Label(container, 2048);
        GridDataFactory.fillDefaults().hint(-1, 0).grab(true, false).span(3, 1).applyTo((Control)horizRule);
        this.overwrite = new Button(container, 32);
        this.overwrite.setText("&Overwrite existing files without warning");
        this.overwrite.setSelection(this.exportModel.getOverwrite());
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.overwrite);
        this.overwrite.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SysdynModelExportPage.this.validatePage();
            }
        });
        this.dependencies = new Button(container, 32);
        this.dependencies.setText("&Include Shared Libraries in exported file");
        this.dependencies.setSelection(this.exportModel.getDependencies());
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.dependencies);
        this.dependencies.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SysdynModelExportPage.this.validatePage();
            }
        });
        try {
            this.initializeData();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        this.setControl((Control)container);
        this.browseFileButton.setFocus();
        this.validatePage();
    }

    private void initializeData() throws DatabaseException {
        Resource selection = ResourceAdaptionUtils.toSingleResource((Object)this.exportModel.getSelection());
        this.models = this.getModels();
        Collections.sort(this.models);
        int i = 0;
        for (NamedResource namedResource : this.models) {
            this.model.add(namedResource.getName());
            if (selection != null && selection.equals(namedResource.getResource())) {
                this.model.select(i);
                this.exportModel.setModel(namedResource);
            } else {
                this.model.select(0);
                for (NamedResource nr : this.models) {
                    if (!this.model.getItem(0).equals(nr.getName())) continue;
                    this.exportModel.setModel(nr);
                }
            }
            ++i;
        }
    }

    private List<NamedResource> getModels() throws DatabaseException {
        return (List)Simantics.getSession().sync((ReadInterface)new UniqueRead<List<NamedResource>>(){

            public List<NamedResource> perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)graph);
                ArrayList<NamedResource> models = new ArrayList<NamedResource>();
                Resource currentProject = Simantics.getProjectResource();
                Collection consistsOfs = graph.getObjects(currentProject, L0.ConsistsOf);
                for (Resource resource : consistsOfs) {
                    if (!graph.isInstanceOf(resource, SYSDYN.SysdynModel)) continue;
                    String modelName = (String)graph.getRelatedValue2(resource, L0.HasName, (Binding)Bindings.STRING);
                    models.add(new NamedResource(modelName, resource));
                }
                return models;
            }
        });
    }

    protected void validatePage() {
        if (this.model.getItemCount() == 0) {
            this.setErrorMessage("There are no exportable Sysdyn models in your workspace.");
            this.setPageComplete(false);
            return;
        }
        String exportLoc = this.exportLocation.getText();
        if (exportLoc.isEmpty()) {
            this.setMessage("Select target file.");
            this.setErrorMessage(null);
            this.setPageComplete(false);
            return;
        }
        if (!exportLoc.endsWith(".sysdyn")) {
            this.setErrorMessage("Wrong file extension! Correct is .sysdyn");
            this.setPageComplete(false);
            return;
        }
        File file = new File(exportLoc);
        if (file.isDirectory()) {
            this.setErrorMessage("The target must be a file, an existing directory was given.");
            this.setPageComplete(false);
            return;
        }
        File parent = file.getParentFile();
        if (parent == null || !parent.isDirectory()) {
            this.setErrorMessage("The target directory does not exist.");
            this.setPageComplete(false);
            return;
        }
        this.exportModel.setExportLocation(file);
        this.exportModel.setOverwrite(this.overwrite.getSelection());
        this.exportModel.setDependencies(this.dependencies.getSelection());
        this.exportModel.setDescription(this.description.getText());
        this.setErrorMessage(null);
        this.setMessage("Export selected model.");
        this.setPageComplete(true);
    }
}

