/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.utils;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.ui.utils.NameValidator;

public class SheetNameValidator
extends NameValidator {
    @Override
    protected boolean nameIsTaken(ReadGraph graph, Resource sheet, String name) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        if (sheet == null) {
            return false;
        }
        Resource book = graph.getPossibleObject(sheet, l0.PartOf);
        if (book == null) {
            return true;
        }
        Resource configurationResource = graph.getPossibleObject(book, l0.PartOf);
        if (configurationResource == null) {
            return true;
        }
        SysdynModel sysdynModel = SysdynModelManager.getInstance((Session)graph.getSession()).getModel(graph, configurationResource);
        sysdynModel.update(graph);
        Resource model = graph.getPossibleObject(configurationResource, l0.PartOf);
        if (model == null) {
            return true;
        }
        if (this.nameTakenByTopLevelVariableOrModule(graph, sysdynModel, sheet, name)) {
            return true;
        }
        if (NameUtils.getSafeName((ReadGraph)graph, (Resource)model).equals(name)) {
            return true;
        }
        if (this.nameTakenByBuiltInFunction(graph, name)) {
            return true;
        }
        if (this.nameTakenBySharedFunctionLibrary(graph, model, null, name)) {
            return true;
        }
        if (this.nameTakenBySheet(graph, configurationResource, sheet, name)) {
            return true;
        }
        return this.nameTakenByItemUnderLibrary(graph, model, null, name);
    }

    @Override
    public void renameInEquations(WriteGraph graph, Resource variable, String originalName, String newName) throws DatabaseException {
    }

    @Override
    public void renameInAllEquations(WriteGraph graph, Resource configuration, String originalName, String newName) throws DatabaseException {
    }
}

