/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.trend;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jfree.chart.JFreeChart;
import org.simantics.jfreechart.chart.ChartUtils;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.trend.TrendView;

public class TrendToSvg
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (part instanceof TrendView) {
            File file;
            MessageDialog dialog;
            TrendView trendView = (TrendView)part;
            Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
            do {
                FileDialog fd = new FileDialog(shell, 8192);
                fd.setText("Export Trend to SVG");
                String[] ext = new String[]{"*.svg"};
                fd.setFilterExtensions(ext);
                String selected = fd.open();
                if (selected == null) {
                    return null;
                }
                file = new File(selected);
                if (!file.exists()) break;
                dialog = new MessageDialog(shell, "Overwrite " + file.getName() + "?", null, String.valueOf(file.getName()) + " exits. Do you wan't to overwrite it?", 0, new String[]{"Yes", "No"}, 0);
                dialog.create();
            } while (dialog.open() == 1);
            try {
                ChartUtils.writeSVG((JFreeChart)trendView.getPanel().getChart(), (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, trendView.getPanel().getWidth(), trendView.getPanel().getHeight()), (File)file);
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.sysdyn.ui", "Save as SVG failed.", (Throwable)e));
            }
            return null;
        }
        return null;
    }
}

