/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.trend;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.ChartUtils;
import org.simantics.jfreechart.chart.properties.RangeHandlerFactory;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.utils.datastructures.Quad;

public class SysdynRangeHandlerFactory
implements RangeHandlerFactory {
    protected Resource getRVIRelation(ReadGraph graph) {
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        return jfree.variableRVI;
    }

    public Read<LinkedHashMap<String, Resource>> getRequest(final Resource series) {
        return new Read<LinkedHashMap<String, Resource>>(){

            public LinkedHashMap<String, Resource> perform(ReadGraph graph) throws DatabaseException {
                Variable v;
                SysdynResource sr;
                block10: {
                    sr = SysdynResource.getInstance((ReadGraph)graph);
                    String realizationURI = ChartUtils.getCurrentRealizationURI((ReadGraph)graph, (Resource)series);
                    String rvi = (String)graph.getPossibleRelatedValue(series, SysdynRangeHandlerFactory.this.getRVIRelation(graph));
                    if (rvi == null) {
                        return null;
                    }
                    if (!(rvi = rvi.replace(".", "/")).startsWith("/")) {
                        rvi = "/" + rvi;
                    }
                    v = Variables.getVariable((ReadGraph)graph, (String)(String.valueOf(realizationURI) + rvi.trim()));
                    if (v != null) break block10;
                    return null;
                }
                try {
                    HashMap<Resource, Resource> redeclarations = new HashMap<Resource, Resource>();
                    Variable parent = v;
                    while ((parent = parent.getParent(graph)) != null) {
                        Resource represents = parent.getRepresents(graph);
                        Resource type = graph.getSingleObject(represents, Layer0.getInstance((ReadGraph)graph).InstanceOf);
                        if (!graph.isInheritedFrom(type, sr.Module)) break;
                        for (Resource redeclaration : graph.getObjects(represents, sr.Module_redeclaration)) {
                            redeclarations.put(graph.getPossibleObject(redeclaration, sr.Redeclaration_replacedEnumeration), graph.getPossibleObject(redeclaration, sr.Redeclaration_replacingEnumeration));
                        }
                    }
                    Resource variable = v.getRepresents(graph);
                    Resource arrayIndexes = graph.getPossibleObject(variable, sr.Variable_arrayIndexesList);
                    if (arrayIndexes != null) {
                        LinkedHashMap<String, Resource> result = new LinkedHashMap<String, Resource>();
                        Iterator iterator = ListUtils.toList((ReadGraph)graph, (Resource)arrayIndexes).iterator();
                        while (iterator.hasNext()) {
                            Resource enumeration;
                            Resource redeclaration = enumeration = (Resource)iterator.next();
                            while (redeclarations.get(redeclaration) != null) {
                                redeclaration = (Resource)redeclarations.get(redeclaration);
                            }
                            String enumerationName = NameUtils.getSafeName((ReadGraph)graph, (Resource)redeclaration);
                            result.put(enumerationName, redeclaration);
                        }
                        return result;
                    }
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
                return null;
            }
        };
    }

    public ReadFactoryImpl<Resource, Map<String, Object>> getRangeItemFactory(int index, Resource res) {
        return new RangeItemFactory(index, res);
    }

    public class RangeItemFactory
    extends ReadFactoryImpl<Resource, Map<String, Object>> {
        private int index;
        private Resource enumeration;
        private boolean addCollections;

        public RangeItemFactory(int index, Resource enumeration) {
            this(index, enumeration, true);
        }

        public RangeItemFactory(int index, Resource enumeration, boolean addCollections) {
            this.index = index;
            this.enumeration = enumeration;
            this.addCollections = addCollections;
        }

        public Object getIdentity(Object inputContents) {
            return new Quad(inputContents, (Object)this.index, (Object)this.enumeration, ((Object)((Object)this)).getClass());
        }

        public Map<String, Object> perform(ReadGraph graph, Resource series) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
            Resource enumerationIndexes = graph.getPossibleObject(this.enumeration, sr.Enumeration_enumerationIndexList);
            List indexes = ListUtils.toList((ReadGraph)graph, (Resource)enumerationIndexes);
            if (this.addCollections) {
                result.put("All", "All");
                result.put("Sum", "Sum");
            }
            for (Resource index : indexes) {
                String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)index);
                result.put(name, name);
            }
            return result;
        }
    }
}

