/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.structure;

import java.util.HashMap;
import java.util.HashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.graphviz.Edge;
import org.simantics.graphviz.Graph;
import org.simantics.graphviz.IGraph;
import org.simantics.graphviz.Identifiable;
import org.simantics.graphviz.Node;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.SysdynResource;

public class ModuleStructureGraphRequest
implements Read<Graph> {
    private Resource resource;

    public ModuleStructureGraphRequest(Resource resource) {
        this.resource = resource;
    }

    public Graph perform(ReadGraph graph) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Graph g = new Graph();
        g.setRankdir("TB");
        Resource model = this.resource;
        while (model != null && !graph.isInstanceOf(model, sr.SysdynModel)) {
            model = graph.getPossibleObject(model, l0.PartOf);
        }
        if (model == null) {
            return g;
        }
        Resource parentResource = graph.getPossibleObject(this.resource, l0.PartOf);
        if (graph.isInstanceOf(parentResource, sr.ConfigurationDiagram)) {
            parentResource = graph.getPossibleObject(parentResource, ModelingResources.getInstance((ReadGraph)graph).DiagramToComposite);
        } else if (graph.isInstanceOf(parentResource, sr.SysdynModel)) {
            parentResource = graph.getPossibleObject(model, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration);
        }
        Node rootNode = new Node((IGraph)g, NameUtils.getSafeLabel((ReadGraph)graph, (Resource)model));
        rootNode.setShape("rectangle");
        HashSet<Resource> visited = new HashSet<Resource>();
        visited.add(model);
        this.findChildModules(g, rootNode, graph, model, parentResource, visited);
        return g;
    }

    private void findChildModules(Graph g, Node parent, ReadGraph graph, Resource resource, Resource parentResource, HashSet<Resource> visited) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource configuration = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(resource, l0.ConsistsOf, sr.Configuration));
        if (configuration.equals(parentResource)) {
            parent.setColor("#ff8c00");
        }
        HashMap<Resource, Integer> modules = new HashMap<Resource, Integer>();
        for (Resource m : graph.getObjects(configuration, l0.ConsistsOf)) {
            Resource type = graph.getPossibleObject(m, l0.InstanceOf);
            if (!graph.isInheritedFrom(type, sr.Module)) continue;
            if (!modules.containsKey(type)) {
                modules.put(type, 0);
            }
            modules.put(type, (Integer)modules.get(type) + 1);
        }
        for (Resource type : modules.keySet()) {
            Node node = new Node((IGraph)g, NameUtils.getSafeName((ReadGraph)graph, (Resource)type));
            node.setShape("rectangle");
            Edge edge = new Edge((IGraph)g, (Identifiable)parent, (Identifiable)node);
            edge.set("labeldistance", "1.5");
            edge.set("labelfontsize", "7");
            edge.setFontColor("#4f4f4f");
            if ((Integer)modules.get(type) > 1) {
                edge.setHeadLabel(((Integer)modules.get(type)).toString());
            }
            if (visited.contains(type)) {
                edge.setFontColor("#FF0000");
                edge.setColor("#FF000");
                edge.setLabel("Error: loop");
                node.setColor("#FF0000");
                node.setFontColor("#FF0000");
                continue;
            }
            HashSet<Resource> copy = new HashSet<Resource>(visited);
            copy.add(type);
            this.findChildModules(g, node, graph, type, parentResource, copy);
        }
    }
}

