/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.arrays;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.utils.ui.ISelectionUtils;

public class ReplaceableIndexesWidget
implements Widget {
    Resource variable = null;
    boolean selected = false;
    Button isReplaceableButton;

    public ReplaceableIndexesWidget(Composite parent, WidgetSupport support, int style) {
        support.register((Widget)this);
        this.isReplaceableButton = new Button(parent, support, style |= 0x20);
        this.isReplaceableButton.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, Boolean>(){

            public Boolean perform(ReadGraph graph, Resource input) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                return (Boolean)graph.getPossibleRelatedValue(ReplaceableIndexesWidget.this.variable, sr.Enumeration_isReplaceable);
            }
        });
        this.isReplaceableButton.setText("Can be replaced by parent module");
    }

    public void setInput(ISessionContext context, Object input) {
        Resource resource;
        ISelection selection;
        if (input instanceof ISelection && (selection = (ISelection)input) instanceof IStructuredSelection && (resource = (Resource)ISelectionUtils.filterSingleSelection((Object)selection, Resource.class)) != null) {
            this.variable = resource;
        }
        if (this.variable == null) {
            return;
        }
        this.isReplaceableButton.setInput(context, input);
        this.isReplaceableButton.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Boolean replaceable = (Boolean)graph.getPossibleRelatedValue(input, sr.Enumeration_isReplaceable);
                if (Boolean.TRUE.equals(replaceable)) {
                    graph.claimLiteral(input, sr.Enumeration_isReplaceable, (Object)false);
                    ReplaceableIndexesWidget.this.selected = false;
                } else {
                    graph.claimLiteral(input, sr.Enumeration_isReplaceable, (Object)true);
                    ReplaceableIndexesWidget.this.selected = true;
                }
                Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Modified " + NameUtils.getSafeName((ReadGraph)graph, (Resource)input) + " can be replaced to " + ReplaceableIndexesWidget.this.selected));
            }
        });
    }

    public org.eclipse.swt.widgets.Button getWidget() {
        return this.isReplaceableButton.getWidget();
    }

    public boolean getSelection() {
        return this.selected;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.isReplaceableButton.addSelectionListener(listener);
    }
}

