/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.Column;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.NodeContextBuilder;
import org.simantics.browsing.ui.swt.SingleSelectionInputSource;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedCombo;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ComboModifyListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.ITrackedColorProvider;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.TrackedModifyEvent;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.DisposableListener;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.properties.AdjustableTab;
import org.simantics.jfreechart.chart.properties.RangeComposite;
import org.simantics.jfreechart.chart.properties.xyline.AxisAndVariablesExplorerComposite;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.properties.RemoveFocusBeforeExperimentComposite;
import org.simantics.sysdyn.ui.properties.SysdynBasicColorProvider;
import org.simantics.sysdyn.ui.properties.widgets.factories.IntegerPropertyFactory;
import org.simantics.sysdyn.ui.properties.widgets.factories.IntegerPropertyModifier;
import org.simantics.sysdyn.ui.properties.widgets.sensitivity.DistributionPropertyWidget;
import org.simantics.sysdyn.ui.properties.widgets.sensitivity.ParameterChildRule;
import org.simantics.sysdyn.ui.properties.widgets.sensitivity.VariableNameModifier;
import org.simantics.sysdyn.ui.validation.ParameterExistsValidator;
import org.simantics.utils.RunnableWithObject;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.validators.IntegerValidator;

public class SensitivityAnalysisExperimentTab
extends AdjustableTab
implements Widget {
    private GraphExplorerComposite explorer;
    private WidgetSupportImpl parameterSupport = new WidgetSupportImpl();
    private ScrolledComposite propertyContainer;
    private Composite parameterProperties;
    private Composite content;
    private Button remove;
    private Resource experiment;
    private boolean dirty = false;
    private boolean dirtyMethod = false;
    private DisposableListener<Collection<Resource>> contentListener;
    private Composite labelComposite;
    private Label labelName;
    private Label labelNumber;
    private Label labelMethod;
    private TrackedCombo methodSelector;
    private Label labelSeed;
    private TrackedText seed;
    private Tree tree;
    private Composite buttonComposite;
    private Group parameterPropertyGroup;
    private Label labelVariable;
    private TrackedText variable;
    private Label labelRange;
    private RangeComposite rangeComposite;
    private Label labelDistribution;
    private TrackedCombo distributionSelector;
    private DistributionPropertyWidget dpw;
    private TrackedText name;
    private TrackedText n;
    private Button addVariable;

    public SensitivityAnalysisExperimentTab(Object id) {
        super(id);
    }

    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        support.register((Widget)this);
        super.createControls(body, site, context, support);
    }

    private void updateSelection(ISessionContext context) {
        ISelectionProvider selectionProvider = (ISelectionProvider)this.explorer.getAdapter(ISelectionProvider.class);
        IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
        this.parameterSupport.fireInput(context, (Object)selection);
        this.propertyContainer.setContent((Control)this.content);
        Point size = this.content.computeSize(-1, -1);
        this.propertyContainer.setMinSize(size);
    }

    public void setInput(ISessionContext context, Object input) {
        this.experiment = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
        if (this.contentListener == null) {
            this.contentListener = new DisposableListener<Collection<Resource>>(){

                public void execute(Collection<Resource> result) {
                    if (SensitivityAnalysisExperimentTab.this.remove != null && !SensitivityAnalysisExperimentTab.this.remove.getWidget().isDisposed() && result != null) {
                        SensitivityAnalysisExperimentTab.this.remove.getWidget().getDisplay().asyncExec((Runnable)new RunnableWithObject(result){

                            public void run() {
                                if (!(this).SensitivityAnalysisExperimentTab.this.remove.getWidget().isDisposed()) {
                                    Collection result = (Collection)this.getObject();
                                    if (result.size() > 1) {
                                        (this).SensitivityAnalysisExperimentTab.this.remove.getWidget().setEnabled(true);
                                    } else {
                                        (this).SensitivityAnalysisExperimentTab.this.remove.getWidget().setEnabled(false);
                                    }
                                }
                            }
                        });
                    }
                }

                public void exception(Throwable t) {
                    t.printStackTrace();
                }
            };
            Simantics.getSession().asyncRequest((Read)new Read<Collection<Resource>>(){

                public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
                    return new ParameterChildRule().getChildren(graph, SensitivityAnalysisExperimentTab.this.experiment);
                }
            }, this.contentListener);
        }
    }

    protected void createAndAddControls(Composite body, IWorkbenchSite site, final ISessionContext context, final WidgetSupport support) {
        this.composite = new RemoveFocusBeforeExperimentComposite(body, 0);
        this.propertyContainer = new ScrolledComposite(this.composite, 768);
        this.propertyContainer.setExpandHorizontal(true);
        this.propertyContainer.setExpandVertical(true);
        this.content = new Composite((Composite)this.propertyContainer, 0);
        this.labelComposite = new Composite(this.content, 0);
        this.labelName = new Label(this.labelComposite, 0);
        this.labelName.setText("Name");
        this.name = new TrackedText(this.labelComposite, support, 2048);
        this.name.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasLabel"));
        this.name.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasLabel"));
        this.name.addModifyListener((TextModifyListener)new StringPropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasName"));
        this.name.setColorProvider((ITrackedColorProvider)new SysdynBasicColorProvider((ResourceManager)new LocalResourceManager(JFaceResources.getResources(), (Control)this.name.getWidget())));
        this.labelNumber = new Label(this.labelComposite, 0);
        this.labelNumber.setText("Number of runs");
        this.n = new TrackedText(this.labelComposite, support, 2048);
        this.n.setTextFactory((ReadFactory)new IntegerPropertyFactory("http://www.simantics.org/Sysdyn-1.1/SensitivityAnalysisExperiment/numberOfValues"));
        this.n.addModifyListener((TextModifyListener)new IntegerPropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/SensitivityAnalysisExperiment/numberOfValues"));
        this.n.setInputValidator((IInputValidator)new IntegerValidator());
        this.n.setColorProvider((ITrackedColorProvider)new SysdynBasicColorProvider((ResourceManager)new LocalResourceManager(JFaceResources.getResources(), (Control)this.n.getWidget())));
        this.labelMethod = new Label(this.labelComposite, 0);
        this.labelMethod.setText("Method");
        this.methodSelector = new TrackedCombo(this.labelComposite, support, 4);
        this.methodSelector.setItemFactory((ReadFactory)new ReadFactoryImpl<Resource, Map<String, Object>>(){

            public Map<String, Object> perform(ReadGraph graph, Resource input) throws DatabaseException {
                SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                HashMap<String, Object> items = new HashMap<String, Object>();
                items.put("Halton", SR.HaltonSequenceGenerator);
                items.put("Random", SR.RandomGenerator);
                return items;
            }
        });
        this.methodSelector.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, String>(){

            public String perform(ReadGraph graph, Resource parameter) throws DatabaseException {
                SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                Resource method = graph.getPossibleObject(parameter, SR.SensitivityAnalysisExperiment_method);
                if (method == null) {
                    return null;
                }
                if (graph.isInstanceOf(method, SR.RandomGenerator)) {
                    return "Random";
                }
                if (graph.isInstanceOf(method, SR.HaltonSequenceGenerator)) {
                    return "Halton";
                }
                return "";
            }
        });
        this.methodSelector.addModifyListener((TextModifyListener)new ComboModifyListenerImpl<Resource>(){

            public void applyText(WriteGraph graph, Resource input, String text) throws DatabaseException {
                if (text == null || text.isEmpty()) {
                    return;
                }
                SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                Resource type = SR.RandomGenerator;
                if ("Halton".equals(text)) {
                    type = SR.HaltonSequenceGenerator;
                }
                graph.deny(input, SR.SensitivityAnalysisExperiment_method);
                GraphUtils.create2((WriteGraph)graph, (Resource)type, (Object[])new Object[]{SR.SensitivityAnalysisExperiment_method_Inverse, input});
                SensitivityAnalysisExperimentTab.this.dirtyMethod = true;
            }
        });
        this.methodSelector.addModifyListener(new TextModifyListener(){

            public void modifyText(TrackedModifyEvent e) {
                if (SensitivityAnalysisExperimentTab.this.dirtyMethod) {
                    support.update();
                    SensitivityAnalysisExperimentTab.this.dirtyMethod = false;
                    SensitivityAnalysisExperimentTab.this.propertyContainer.setContent((Control)SensitivityAnalysisExperimentTab.this.content);
                    Point size = SensitivityAnalysisExperimentTab.this.content.computeSize(-1, -1);
                    SensitivityAnalysisExperimentTab.this.propertyContainer.setMinSize(size);
                }
            }
        });
        this.labelSeed = new Label(this.labelComposite, 0);
        this.labelSeed.setText("Seed");
        this.seed = new TrackedText(this.labelComposite, support, 2048);
        this.seed.setTextFactory((ReadFactory)new IntegerPropertyFactory("http://www.simantics.org/Sysdyn-1.1/SensitivityAnalysisExperiment/randomSeed"));
        this.seed.addModifyListener((TextModifyListener)new IntegerPropertyModifier(context, "http://www.simantics.org/Sysdyn-1.1/SensitivityAnalysisExperiment/randomSeed"));
        this.seed.setInputValidator((IInputValidator)new IntegerValidator());
        this.seed.setColorProvider((ITrackedColorProvider)new SysdynBasicColorProvider((ResourceManager)new LocalResourceManager(JFaceResources.getResources(), (Control)this.seed.getWidget())));
        this.explorer = new AxisAndVariablesExplorerComposite((Map)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter", "treeView"}).values(new Object[]{false, false, true}), site, this.content, support, 67588);
        this.explorer.setBrowseContexts(new String[]{"http://www.simantics.org/Sysdyn-1.1/SensitivityAnalysisExperiment/ParameterBrowseContext"});
        this.explorer.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(Resource.class));
        this.explorer.getExplorer().setAutoExpandLevel(2);
        this.explorer.setColumns(new Column[]{new Column("single", Column.Align.LEFT, 0, "", true)});
        this.explorer.finish();
        ((Tree)this.explorer.getExplorerControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SensitivityAnalysisExperimentTab.this.updateSelection(context);
            }
        });
        Listener listener = new Listener(){
            boolean flag = false;

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: 
                    case 22: 
                    case 26: {
                        if (this.flag || ((Tree)event.widget).getItems().length <= 0) break;
                        this.flag = true;
                        TreeItem item = ((Tree)event.widget).getItems()[0];
                        IAdaptable adaptable = (IAdaptable)item.getData();
                        NodeContextBuilder.MapNodeContext nc = (NodeContextBuilder.MapNodeContext)adaptable.getAdapter(NodeContext.class);
                        SensitivityAnalysisExperimentTab.this.parameterSupport.fireInput(context, (Object)new StructuredSelection(nc.getConstant(BuiltinKeys.INPUT)));
                        SensitivityAnalysisExperimentTab.this.propertyContainer.setContent((Control)SensitivityAnalysisExperimentTab.this.content);
                        Point size = SensitivityAnalysisExperimentTab.this.content.computeSize(-1, -1);
                        SensitivityAnalysisExperimentTab.this.propertyContainer.setMinSize(size);
                    }
                }
            }
        };
        this.tree = (Tree)this.explorer.getExplorerControl();
        this.tree.addListener(26, listener);
        this.tree.addListener(22, listener);
        this.tree.addListener(9, listener);
        this.explorer.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (SensitivityAnalysisExperimentTab.this.contentListener != null) {
                    SensitivityAnalysisExperimentTab.this.contentListener.dispose();
                }
            }
        });
        this.buttonComposite = new Composite((Composite)this.explorer, 0);
        this.addVariable = new Button(this.buttonComposite, support, 0);
        this.addVariable.setText("Add parameter");
        this.addVariable.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                Resource distribution = GraphUtils.create2((WriteGraph)graph, (Resource)sr.UniformDistribution, (Object[])new Object[]{sr.UniformDistribution_minValue, 0.0, sr.UniformDistribution_maxValue, 10.0});
                Resource parameter = GraphUtils.create2((WriteGraph)graph, (Resource)sr.SensitivityAnalysisExperiment_Parameter, (Object[])new Object[]{sr.SensitivityAnalysisExperiment_Parameter_propabilityDistribution, distribution, sr.SensitivityAnalysisExperiment_Parameter_variable, "<Write variable name>", L0.PartOf, input});
                Resource parameterList = graph.getPossibleObject(input, sr.SensitivityAnalysisExperiment_parameterList);
                ListUtils.insertBack((WriteGraph)graph, (Resource)parameterList, Collections.singleton(parameter));
            }
        });
        this.remove = new Button(this.buttonComposite, (WidgetSupport)this.parameterSupport, 0);
        this.remove.setText("Remove");
        this.remove.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource input) throws DatabaseException {
                if (input == null) {
                    return;
                }
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                Resource experiment = graph.getPossibleObject(input, L0.PartOf);
                Resource parameterList = graph.getPossibleObject(experiment, sr.SensitivityAnalysisExperiment_parameterList);
                if (ListUtils.toList((ReadGraph)graph, (Resource)parameterList).size() > 1) {
                    ListUtils.removeElement((WriteGraph)graph, (Resource)parameterList, (Resource)input);
                }
            }
        });
        this.propertyContainer.setContent((Control)this.content);
        this.parameterPropertyGroup = new Group(this.content, 0);
        this.parameterProperties = new Composite((Composite)this.parameterPropertyGroup, 0);
        this.labelVariable = new Label(this.parameterProperties, 0);
        this.labelVariable.setText("Variable:");
        this.variable = new TrackedText(this.parameterProperties, (WidgetSupport)this.parameterSupport, 2048);
        this.variable.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Sysdyn-1.1/SensitivityAnalysisExperiment/Parameter/variable"));
        this.variable.addModifyListener((TextModifyListener)new VariableNameModifier((Control)this.variable.getWidget(), (WidgetSupport)this.parameterSupport, "http://www.simantics.org/Sysdyn-1.1/SensitivityAnalysisExperiment/Parameter/variable", "http://www.simantics.org/Sysdyn-1.1/SensitivityAnalysisExperiment/Parameter/indexes"));
        this.variable.setColorProvider((ITrackedColorProvider)new SysdynBasicColorProvider((ResourceManager)new LocalResourceManager(JFaceResources.getResources(), (Control)this.variable.getWidget())));
        this.variable.setInputValidator((IInputValidator)new ParameterExistsValidator((WidgetSupport)this.parameterSupport, this.variable));
        this.labelRange = new Label(this.parameterProperties, 0);
        this.labelRange.setText("Range:");
        this.rangeComposite = new RangeComposite(this.parameterProperties, context, (WidgetSupport)this.parameterSupport, 0){

            protected Resource getIndexRelation(ReadGraph graph) {
                return SysdynResource.getInstance((ReadGraph)graph).SensitivityAnalysisExperiment_Parameter_indexes;
            }
        };
        this.labelDistribution = new Label(this.parameterProperties, 0);
        this.labelDistribution.setText("Distribution:");
        this.distributionSelector = new TrackedCombo(this.parameterProperties, (WidgetSupport)this.parameterSupport, 4);
        this.distributionSelector.setItemFactory((ReadFactory)new ReadFactoryImpl<Resource, Map<String, Object>>(){

            public Map<String, Object> perform(ReadGraph graph, Resource input) throws DatabaseException {
                SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                HashMap<String, Object> items = new HashMap<String, Object>();
                items.put("Normal", SR.NormalDistribution);
                items.put("Uniform", SR.UniformDistribution);
                items.put("Interval", SR.Interval);
                return items;
            }
        });
        this.distributionSelector.setSelectionFactory((ReadFactory)new ReadFactoryImpl<Resource, String>(){

            public String perform(ReadGraph graph, Resource parameter) throws DatabaseException {
                SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                Resource distribution = graph.getPossibleObject(parameter, SR.SensitivityAnalysisExperiment_Parameter_propabilityDistribution);
                if (distribution == null) {
                    return null;
                }
                if (graph.isInstanceOf(distribution, SR.UniformDistribution)) {
                    return "Uniform";
                }
                if (graph.isInstanceOf(distribution, SR.NormalDistribution)) {
                    return "Normal";
                }
                if (graph.isInstanceOf(distribution, SR.Interval)) {
                    return "Interval";
                }
                return "";
            }
        });
        this.distributionSelector.addModifyListener((TextModifyListener)new ComboModifyListenerImpl<Resource>(){

            public void applyText(WriteGraph graph, Resource input, String text) throws DatabaseException {
                if (text == null || text.isEmpty()) {
                    return;
                }
                SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                Resource type = SR.UniformDistribution;
                if ("Normal".equals(text)) {
                    type = SR.NormalDistribution;
                } else if ("Interval".equals(text)) {
                    type = SR.Interval;
                }
                graph.deny(input, SR.SensitivityAnalysisExperiment_Parameter_propabilityDistribution);
                GraphUtils.create2((WriteGraph)graph, (Resource)type, (Object[])new Object[]{SR.SensitivityAnalysisExperiment_Parameter_propabilityDistribution_Inverse, input});
                SensitivityAnalysisExperimentTab.this.dirty = true;
            }
        });
        this.distributionSelector.addModifyListener(new TextModifyListener(){

            public void modifyText(TrackedModifyEvent e) {
                if (SensitivityAnalysisExperimentTab.this.dirty) {
                    SensitivityAnalysisExperimentTab.this.parameterSupport.update();
                    SensitivityAnalysisExperimentTab.this.dirty = false;
                    SensitivityAnalysisExperimentTab.this.propertyContainer.setContent((Control)SensitivityAnalysisExperimentTab.this.content);
                    Point size = SensitivityAnalysisExperimentTab.this.content.computeSize(-1, -1);
                    SensitivityAnalysisExperimentTab.this.propertyContainer.setMinSize(size);
                }
            }
        });
        this.dpw = new DistributionPropertyWidget(this.parameterProperties, context, (WidgetSupport)this.parameterSupport, 0);
    }

    protected void createControlLayoutVertical() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.propertyContainer);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.propertyContainer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.content);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(this.content);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)this.labelComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.labelComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.name.getWidget());
        GridDataFactory.fillDefaults().hint(50, -1).applyTo((Control)this.n.getWidget());
        GridDataFactory.fillDefaults().hint(50, -1).applyTo((Control)this.seed.getWidget());
        GridDataFactory.fillDefaults().hint(150, -1).grab(false, true).applyTo((Control)this.explorer);
        GridDataFactory.fillDefaults().applyTo((Control)this.buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.buttonComposite);
        Point tsize = this.content.computeSize(-1, -1);
        this.propertyContainer.setMinSize(tsize);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.parameterPropertyGroup);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.parameterPropertyGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.parameterProperties);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.parameterProperties);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelVariable);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.variable.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelRange);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.rangeComposite);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelDistribution);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).applyTo((Control)this.dpw);
        GridLayoutFactory.fillDefaults().margins(6, 0).applyTo((Composite)this.dpw);
    }

    protected void createControlLayoutHorizontal(boolean wideScreen) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.propertyContainer);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.propertyContainer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.content);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.content);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.labelComposite);
        GridLayoutFactory.fillDefaults().numColumns(8).applyTo(this.labelComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.name.getWidget());
        GridDataFactory.fillDefaults().hint(50, -1).applyTo((Control)this.n.getWidget());
        GridDataFactory.fillDefaults().hint(50, -1).applyTo((Control)this.seed.getWidget());
        GridDataFactory.fillDefaults().hint(250, -1).grab(false, true).applyTo((Control)this.explorer);
        GridDataFactory.fillDefaults().applyTo((Control)this.buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.buttonComposite);
        Point tsize = this.content.computeSize(-1, -1);
        this.propertyContainer.setMinSize(tsize);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.parameterPropertyGroup);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.parameterPropertyGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.parameterProperties);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.parameterProperties);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelVariable);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.variable.getWidget());
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelRange);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)this.rangeComposite);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.labelDistribution);
        GridDataFactory.fillDefaults().span(1, 1).grab(true, true).applyTo((Control)this.dpw);
        GridLayoutFactory.fillDefaults().margins(6, 0).applyTo((Composite)this.dpw);
    }
}

