/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.jfreechart.chart.properties.LabelPropertyTabContributor;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.utils.datastructures.Triple;
import org.simantics.utils.ui.color.Color;
import org.simantics.utils.ui.color.ColorGradient;
import org.simantics.utils.ui.color.ColorValue;

public class PlaybackExperimentTab
extends LabelPropertyTabContributor {
    private static int gradientWidth = 250;
    private static int gradientHeight = 20;

    public PlaybackExperimentTab(Object id) {
        super(id);
    }

    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        Composite composite = new Composite(body, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo(composite);
        Group gradientGroup = new Group(composite, 0);
        gradientGroup.setText("Color scale");
        GridDataFactory.fillDefaults().applyTo((Control)gradientGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).applyTo((Composite)gradientGroup);
        ColorValue cv1 = new ColorValue(new Color(0, 62, 133), 0.0);
        ColorValue cv2 = new ColorValue(new Color(255, 230, 0), 1.0);
        ColorValue[] values = new ColorValue[]{cv1, cv2};
        ColorGradient cg = new ColorGradient(values, 1);
        Image image = cg.getGradientImage(gradientWidth, gradientHeight, 256);
        Button b = new Button((Composite)gradientGroup, support, 16);
        GridDataFactory.fillDefaults().hint(gradientWidth, gradientHeight).applyTo((Control)b.getWidget());
        b.setImage(image);
        b.addSelectionListener((SelectionListener)new GradientSelectionListener(context, values));
        b.setSelectionFactory((ReadFactory)new GradientSelectionFactory(values));
        cv1 = new ColorValue(new Color(255, 230, 0), 0.0);
        cv2 = new ColorValue(new Color(0, 62, 133), 1.0);
        values = new ColorValue[]{cv1, cv2};
        cg = new ColorGradient(values, 1);
        image = cg.getGradientImage(gradientWidth, gradientHeight, 256);
        b = new Button((Composite)gradientGroup, support, 16);
        GridDataFactory.fillDefaults().hint(gradientWidth, gradientHeight).applyTo((Control)b.getWidget());
        b.setImage(image);
        b.addSelectionListener((SelectionListener)new GradientSelectionListener(context, values));
        b.setSelectionFactory((ReadFactory)new GradientSelectionFactory(values));
        cv1 = new ColorValue(new Color(0, 0, 0), 0.0);
        cv2 = new ColorValue(new Color(255, 255, 255), 1.0);
        values = new ColorValue[]{cv1, cv2};
        cg = new ColorGradient(values, 1);
        image = cg.getGradientImage(gradientWidth, gradientHeight, 256);
        b = new Button((Composite)gradientGroup, support, 16);
        GridDataFactory.fillDefaults().hint(gradientWidth, gradientHeight).applyTo((Control)b.getWidget());
        b.setImage(image);
        b.addSelectionListener((SelectionListener)new GradientSelectionListener(context, values));
        b.setSelectionFactory((ReadFactory)new GradientSelectionFactory(values));
        cv1 = new ColorValue(new Color(0, 0, 255), 0.0);
        cv2 = new ColorValue(new Color(255, 0, 0), 1.0);
        values = new ColorValue[]{cv1, cv2};
        cg = new ColorGradient(values, 1);
        image = cg.getGradientImage(gradientWidth, gradientHeight, 256);
        b = new Button((Composite)gradientGroup, support, 16);
        GridDataFactory.fillDefaults().hint(gradientWidth, gradientHeight).applyTo((Control)b.getWidget());
        b.setImage(image);
        b.addSelectionListener((SelectionListener)new GradientSelectionListener(context, values));
        b.setSelectionFactory((ReadFactory)new GradientSelectionFactory(values));
        cv1 = new ColorValue(new Color(255, 0, 0), 0.0);
        cv2 = new ColorValue(new Color(0, 0, 255), 1.0);
        values = new ColorValue[]{cv1, cv2};
        cg = new ColorGradient(values, 1);
        image = cg.getGradientImage(gradientWidth, gradientHeight, 256);
        b = new Button((Composite)gradientGroup, support, 16);
        GridDataFactory.fillDefaults().hint(gradientWidth, gradientHeight).applyTo((Control)b.getWidget());
        b.setImage(image);
        b.addSelectionListener((SelectionListener)new GradientSelectionListener(context, values));
        b.setSelectionFactory((ReadFactory)new GradientSelectionFactory(values));
    }

    class GradientSelectionFactory
    extends ReadFactoryImpl<Resource, Boolean> {
        private ArrayList<ColorValue> colorValues = new ArrayList();

        public GradientSelectionFactory(ColorValue[] colorValues) {
            ColorValue[] colorValueArray = colorValues;
            int n = colorValues.length;
            int n2 = 0;
            while (n2 < n) {
                ColorValue cv = colorValueArray[n2];
                this.colorValues.add(cv);
                ++n2;
            }
        }

        public Object getIdentity(Object inputContents) {
            return new Triple(inputContents, this.colorValues, ((Object)((Object)this)).getClass());
        }

        public Boolean perform(ReadGraph graph, Resource experiment) throws DatabaseException {
            G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
            Resource gradient = graph.getPossibleObject(experiment, g2d.HasColorGradient);
            if (gradient == null) {
                return Boolean.FALSE;
            }
            Collection placements = (Collection)graph.syncRequest((Read)new ObjectsWithType(gradient, g2d.HasColorPlacement, g2d.ColorPlacement));
            if (placements.isEmpty()) {
                return Boolean.FALSE;
            }
            for (Resource placement : placements) {
                Double position = (Double)graph.getPossibleRelatedValue(placement, g2d.HasGradientPosition);
                if (position == null) {
                    return Boolean.FALSE;
                }
                int index = -1;
                int i = 0;
                while (i < this.colorValues.size()) {
                    if (position.equals(this.colorValues.get(i).getValue())) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                if (index < 0) continue;
                Color c = this.colorValues.get(index).getColor();
                float[] cArray = c.getAWTColor().getColorComponents(new float[4]);
                float[] color = (float[])graph.getPossibleRelatedValue(placement, g2d.HasColor, (Binding)Bindings.FLOAT_ARRAY);
                int i2 = 0;
                while (i2 < color.length) {
                    if (cArray[i2] != color[i2]) {
                        return Boolean.FALSE;
                    }
                    ++i2;
                }
            }
            return Boolean.TRUE;
        }
    }

    class GradientSelectionListener
    extends SelectionListenerImpl<Resource> {
        private ArrayList<ColorValue> colorValues;

        public GradientSelectionListener(ISessionContext context, ColorValue[] colorValues) {
            super(context);
            this.colorValues = new ArrayList();
            ColorValue[] colorValueArray = colorValues;
            int n = colorValues.length;
            int n2 = 0;
            while (n2 < n) {
                ColorValue cv = colorValueArray[n2];
                this.colorValues.add(cv);
                ++n2;
            }
        }

        public void apply(WriteGraph graph, Resource experiment) throws DatabaseException {
            G2DResource g2d = G2DResource.getInstance((ReadGraph)graph);
            Resource gradient = graph.getPossibleObject(experiment, g2d.HasColorGradient);
            if (gradient != null) {
                graph.denyStatement(experiment, g2d.HasColorGradient, gradient);
                RemoverUtil.remove((WriteGraph)graph, (Resource)gradient);
            }
            gradient = GraphUtils.create2((WriteGraph)graph, (Resource)g2d.ColorGradient, (Object[])new Object[0]);
            graph.claim(experiment, g2d.HasColorGradient, gradient);
            for (ColorValue cv : this.colorValues) {
                Resource placement = GraphUtils.create2((WriteGraph)graph, (Resource)g2d.ColorPlacement, (Object[])new Object[]{g2d.HasGradientPosition, cv.getValue()});
                graph.claimLiteral(placement, g2d.HasColor, g2d.Color, (Object)cv.getColor().getAWTColor().getColorComponents(new float[4]));
                graph.claim(gradient, g2d.HasColorPlacement, placement);
            }
        }
    }
}

