/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.util.ArrayList;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.widgets.Scale;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.jfreechart.chart.properties.LabelPropertyTabContributor;
import org.simantics.sysdyn.SysdynResource;

public class ArrayFlowTab
extends LabelPropertyTabContributor {
    private Scale lineThicknessScale;

    public ArrayFlowTab(Object input) {
        super(input);
    }

    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        Composite composite = new Composite(body, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(1).applyTo(composite);
        Group lineThicknessGroup = new Group(composite, 0);
        GridDataFactory.fillDefaults().applyTo((Control)lineThicknessGroup);
        GridLayoutFactory.fillDefaults().applyTo((Composite)lineThicknessGroup);
        lineThicknessGroup.setText("Flow thickness:");
        this.lineThicknessScale = new Scale((Composite)lineThicknessGroup, support, 256);
        this.lineThicknessScale.getWidget().setMinimum(1);
        this.lineThicknessScale.getWidget().setMaximum(9);
        this.lineThicknessScale.getWidget().setPageIncrement(1);
        this.lineThicknessScale.getWidget().setIncrement(1);
        this.lineThicknessScale.setSelectionFactory((ReadFactory)new LineThicknessRadioSelectionFactory());
        this.lineThicknessScale.addSelectionListener((SelectionListener)new LineThicknessSelectionListener(context, this.lineThicknessScale));
    }

    class LineThicknessRadioSelectionFactory
    extends ReadFactoryImpl<ArrayList<Resource>, Integer> {
        public Integer perform(ReadGraph graph, ArrayList<Resource> flowConnection) throws DatabaseException {
            Float width;
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            if (flowConnection.size() > 0 && (width = (Float)graph.getPossibleRelatedValue(flowConnection.get(0), sr.FlowConnection_width, (Binding)Bindings.FLOAT)) != null) {
                return Math.round(width.floatValue() * 3.0f);
            }
            return Math.round(3.0f);
        }
    }

    class LineThicknessSelectionListener
    extends SelectionListenerImpl<ArrayList<Resource>> {
        Scale scale;
        private int selection;

        public LineThicknessSelectionListener(ISessionContext context, Scale scale) {
            super(context);
            this.scale = scale;
        }

        public void beforeApply() {
            this.selection = this.scale.getWidget().getSelection();
        }

        public void apply(WriteGraph graph, ArrayList<Resource> connectionElements) throws DatabaseException {
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
            float width = (float)this.selection / 3.0f;
            for (Resource r : connectionElements) {
                graph.claimLiteral(r, sr.FlowConnection_width, (Object)Float.valueOf(width));
            }
        }
    }
}

