/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.preferences;

import java.util.HashMap;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.preferences.SysdynDiagramPreferences;

public class SysdynDiagramPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private HashMap<FieldEditor, Composite> fieldParents;
    private Group colorEditors;
    private Group fontEditors;

    public SysdynDiagramPreferencePage() {
        super(1);
        this.setDescription("System dynamics diagram preferences");
        this.fieldParents = new HashMap();
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite parent = new Composite(this.getFieldEditorParent(), 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(parent);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)parent);
        Group defaults = new Group(parent, 0);
        defaults.setText("Default settings");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)defaults);
        this.addField((FieldEditor)new ColorFieldEditor(SysdynDiagramPreferences.DEFAULT_COLOR, "Color", (Composite)defaults));
        this.addField((FieldEditor)new CustomFontFieldEditor(SysdynDiagramPreferences.DEFAULT_FONT, "Font", (Composite)defaults));
        GridLayout layout = (GridLayout)defaults.getLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        defaults.setLayout((Layout)layout);
        this.colorEditors = new Group(parent, 0);
        this.colorEditors.setText("Colors");
        GridDataFactory.fillDefaults().applyTo((Control)this.colorEditors);
        GridDataFactory.fillDefaults().applyTo((Control)this.colorEditors);
        Label label = new Label((Composite)this.colorEditors, 0);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)label);
        label = new Label((Composite)this.colorEditors, 0);
        label.setText("Use default");
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.addColorFieldEditor(SysdynDiagramPreferences.ARROW_COLOR, "&Dependency", SysdynDiagramPreferences.ARROW_USE_DEFAULT_COLOR);
        this.addColorFieldEditor(SysdynDiagramPreferences.ARROW_STOCK_INITIAL_COLOR, "&Dependency to Stock Initial", SysdynDiagramPreferences.ARROW_STOCK_INITIAL_USE_DEFAULT_COLOR);
        this.addColorFieldEditor(SysdynDiagramPreferences.FLOW_COLOR, "&Flow", SysdynDiagramPreferences.FLOW_USE_DEFAULT_COLOR);
        this.addColorFieldEditor(SysdynDiagramPreferences.AUXILIARY_COLOR, "&Auxiliary", SysdynDiagramPreferences.AUXILIARY_USE_DEFAULT_COLOR);
        this.addColorFieldEditor(SysdynDiagramPreferences.STOCK_COLOR, "&Stock", SysdynDiagramPreferences.STOCK_USE_DEFAULT_COLOR);
        this.addColorFieldEditor(SysdynDiagramPreferences.VALVE_COLOR, "&Valve", SysdynDiagramPreferences.VALVE_USE_DEFAULT_COLOR);
        this.addColorFieldEditor(SysdynDiagramPreferences.INPUT_COLOR, "&Input", SysdynDiagramPreferences.VALVE_USE_DEFAULT_COLOR);
        this.addColorFieldEditor(SysdynDiagramPreferences.CLOUD_COLOR, "&Cloud", SysdynDiagramPreferences.CLOUD_USE_DEFAULT_COLOR);
        this.addColorFieldEditor(SysdynDiagramPreferences.MODULE_COLOR, "&Module", SysdynDiagramPreferences.MODULE_USE_DEFAULT_COLOR);
        this.fontEditors = new Group(parent, 0);
        this.fontEditors.setText("Fonts");
        GridDataFactory.fillDefaults().applyTo((Control)this.fontEditors);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.fontEditors);
        label = new Label((Composite)this.fontEditors, 0);
        GridDataFactory.fillDefaults().span(3, 1).applyTo((Control)label);
        label = new Label((Composite)this.fontEditors, 0);
        label.setText("Use default");
        GridDataFactory.fillDefaults().applyTo((Control)label);
        this.addFontFieldEditor(SysdynDiagramPreferences.ARROW_FONT, "Dependency", SysdynDiagramPreferences.ARROW_USE_DEFAULT_FONT);
        this.addFontFieldEditor(SysdynDiagramPreferences.AUXILIARY_FONT, "Auxiliary", SysdynDiagramPreferences.AUXILIARY_USE_DEFAULT_FONT);
        this.addFontFieldEditor(SysdynDiagramPreferences.STOCK_FONT, "Stock", SysdynDiagramPreferences.STOCK_USE_DEFAULT_FONT);
        this.addFontFieldEditor(SysdynDiagramPreferences.VALVE_FONT, "Valve", SysdynDiagramPreferences.VALVE_USE_DEFAULT_FONT);
        this.addFontFieldEditor(SysdynDiagramPreferences.INPUT_FONT, "Input", SysdynDiagramPreferences.INPUT_USE_DEFAULT_FONT);
        this.addFontFieldEditor(SysdynDiagramPreferences.CLOUD_FONT, "Cloud", SysdynDiagramPreferences.CLOUD_USE_DEFAULT_FONT);
        this.addFontFieldEditor(SysdynDiagramPreferences.MODULE_FONT, "Module", SysdynDiagramPreferences.MODULE_USE_DEFAULT_FONT);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(4).applyTo((Composite)this.colorEditors);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(4).applyTo((Composite)this.fontEditors);
    }

    private void addColorFieldEditor(String property, String label, String defaultBoolean) {
        ColorFieldEditor colorField = new ColorFieldEditor(property, label, (Composite)this.colorEditors);
        colorField.setEnabled(!this.getPreferenceStore().getBoolean(defaultBoolean), (Composite)this.colorEditors);
        Composite c = new Composite((Composite)this.colorEditors, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)c);
        GridLayoutFactory.fillDefaults().applyTo(c);
        DefaultBooleanFiedEditor useDefault = new DefaultBooleanFiedEditor((FieldEditor)colorField, defaultBoolean, c);
        this.fieldParents.put((FieldEditor)colorField, (Composite)this.colorEditors);
        this.addField((FieldEditor)useDefault);
        this.addField((FieldEditor)colorField);
    }

    private void addFontFieldEditor(String property, String label, String defaultBoolean) {
        CustomFontFieldEditor fontField = new CustomFontFieldEditor(property, label, (Composite)this.fontEditors);
        fontField.setEnabled(!this.getPreferenceStore().getBoolean(defaultBoolean), (Composite)this.fontEditors);
        Composite c = new Composite((Composite)this.fontEditors, 0);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)c);
        GridLayoutFactory.fillDefaults().applyTo(c);
        DefaultBooleanFiedEditor useDefault = new DefaultBooleanFiedEditor((FieldEditor)fontField, defaultBoolean, c);
        this.fieldParents.put((FieldEditor)fontField, (Composite)this.fontEditors);
        this.addField((FieldEditor)useDefault);
        this.addField((FieldEditor)fontField);
    }

    private class CustomFontFieldEditor
    extends FontFieldEditor {
        public CustomFontFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
            GridDataFactory.fillDefaults().applyTo((Control)this.getChangeControl(parent));
            this.setChangeButtonText("...");
            this.getChangeControl(parent).setToolTipText("Change");
        }
    }

    private class DefaultBooleanFiedEditor
    extends BooleanFieldEditor {
        private FieldEditor fieldEditor;

        public DefaultBooleanFiedEditor(FieldEditor fieldEditor, String name, Composite parent) {
            super(name, "", parent);
            this.fieldEditor = fieldEditor;
        }

        protected void valueChanged(boolean oldValue, boolean newValue) {
            super.valueChanged(oldValue, newValue);
            this.fieldEditor.setEnabled(!newValue, SysdynDiagramPreferencePage.this.fieldParents.get(this.fieldEditor));
        }
    }
}

