/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.preferences;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.modelica.ModelicaManager;
import org.simantics.modelica.preferences.OpenModelicaPreferences;

public class ModelicaPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static String CUSTOM_PATH = "Custom path";
    private DirectoryFieldEditor path;
    private RadioGroupFieldEditor rg;

    public ModelicaPreferencePage() {
        super(1);
        this.setDescription("Modelica preferences");
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(ConfigurationScope.INSTANCE, "org.simantics.modelica"));
    }

    public void createFieldEditors() {
        final File installed = ModelicaManager.getInstalledOMHome();
        final File builtIn = ModelicaManager.getBuiltinOMHome();
        ArrayList<String[]> optionList = new ArrayList<String[]>();
        optionList.add(new String[]{CUSTOM_PATH, CUSTOM_PATH});
        if (installed != null) {
            optionList.add(new String[]{"Local installation (" + ModelicaManager.getOMVersion((File)installed) + ")", installed.getAbsolutePath()});
        }
        if (builtIn != null) {
            optionList.add(new String[]{"Built-in (" + ModelicaManager.getOMVersion((File)builtIn) + ")", builtIn.getAbsolutePath()});
        }
        String[][] options = (String[][])optionList.toArray((T[])new String[optionList.size()][]);
        this.rg = new RadioGroupFieldEditor(OpenModelicaPreferences.OM_HOME, "&Choose the used OpenModelica version", 1, options, this.getFieldEditorParent()){

            protected void doStore() {
            }

            protected void fireValueChanged(String property, Object oldValue, Object newValue) {
                if (installed != null && newValue.equals(installed.getAbsolutePath()) || builtIn != null && newValue.equals(builtIn.getAbsolutePath())) {
                    ModelicaPreferencePage.this.path.setStringValue((String)newValue);
                    ModelicaPreferencePage.this.path.setEnabled(false, ModelicaPreferencePage.this.getFieldEditorParent());
                } else {
                    ModelicaPreferencePage.this.path.setEnabled(true, ModelicaPreferencePage.this.getFieldEditorParent());
                }
            }

            public void doLoadDefault() {
                IScopeContext context = ConfigurationScope.INSTANCE;
                IEclipsePreferences node = context.getNode("org.simantics.modelica");
                File omhome = ModelicaManager.getDefaultOMHome();
                node.put(OpenModelicaPreferences.OM_HOME, omhome != null ? omhome.getAbsolutePath() : "");
                this.load();
            }
        };
        this.addField((FieldEditor)this.rg);
        this.path = new DirectoryFieldEditor(OpenModelicaPreferences.OM_HOME, "&Modelica Home:", this.getFieldEditorParent()){

            public void setValidateStrategy(int value) {
                super.setValidateStrategy(0);
            }

            public void doStore() {
                super.doStore();
                IScopeContext context = ConfigurationScope.INSTANCE;
                IEclipsePreferences node = context.getNode("org.simantics.modelica");
                node.put(OpenModelicaPreferences.OM_HOME, this.getStringValue());
            }

            protected boolean doCheckState() {
                boolean valid = super.doCheckState();
                if (valid) {
                    String path = this.getStringValue();
                    if (path.isEmpty()) {
                        return true;
                    }
                    File dir = new File(path);
                    String version = ModelicaManager.getOMVersion((File)dir);
                    if (version == null || version.isEmpty()) {
                        return false;
                    }
                }
                return valid;
            }

            public void doLoad() {
                super.doLoad();
                String value = this.getStringValue();
                this.updatePath(value);
            }

            public void doLoadDefault() {
                File omhome = ModelicaManager.getDefaultOMHome();
                this.updatePath(omhome != null ? omhome.getAbsolutePath() : "");
            }

            private void updatePath(String newValue) {
                if (installed != null && newValue.equals(installed.getAbsolutePath()) || builtIn != null && newValue.equals(builtIn.getAbsolutePath())) {
                    ModelicaPreferencePage.this.path.setStringValue(newValue);
                    ModelicaPreferencePage.this.path.setEnabled(false, ModelicaPreferencePage.this.getFieldEditorParent());
                } else {
                    ModelicaPreferencePage.this.path.setEnabled(true, ModelicaPreferencePage.this.getFieldEditorParent());
                }
            }
        };
        this.path.setErrorMessage("Path must be a valid OpenModelica directory or left empty");
        this.path.setEmptyStringAllowed(true);
        this.addField((FieldEditor)this.path);
    }
}

