/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.experiment.IExperimentListener;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.simulation.project.IExperimentManagerListener;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.manager.SysdynPlaybackExperiment;
import org.simantics.sysdyn.manager.SysdynSensitivityAnalysisExperimentBase;
import org.simantics.sysdyn.ui.listeners.SysdynExperimentListener;
import org.simantics.sysdyn.ui.listeners.SysdynPlaybackExperimentListener;

public class SysdynExperimentManagerListener
implements IExperimentManagerListener {
    public static final String BASIC_EXPERIMENT_CONTEXT = "org.simantics.sysdyn.ui.basicExperiment";
    public static final String PLAYBACK_EXPERIMENT_CONTEXT = "org.simantics.sysdyn.ui.playbackExperiment";
    public static final String GAME_EXPERIMENT_CONTEXT = "org.simantics.sysdyn.ui.gameExperiment";
    public static final String SENSITIVITY_ANALYSIS_EXPERIMENT_CONTEXT = "org.simantics.sysdyn.ui.sensitivityAnalysisExperiment";
    static Set<IExperimentManager> managers = new HashSet<IExperimentManager>();
    IExperimentManager manager;
    Collection<IContextActivation> contextActivations = new ArrayList<IContextActivation>();

    public SysdynExperimentManagerListener(IExperimentManager manager) {
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void listenManager(IExperimentManager manager) {
        Set<IExperimentManager> set = managers;
        synchronized (set) {
            if (managers.contains(manager)) {
                return;
            }
            SysdynExperimentManagerListener listener = new SysdynExperimentManagerListener(manager);
            manager.addListener((IExperimentManagerListener)listener);
            managers.add(manager);
        }
    }

    public void activeExperimentLoaded(final IExperiment experiment) {
        experiment.addListener((IExperimentListener)new SysdynExperimentListener());
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                IContextService contextService = (IContextService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IContextService.class);
                Collection<IContextActivation> collection = SysdynExperimentManagerListener.this.contextActivations;
                synchronized (collection) {
                    if (experiment instanceof SysdynPlaybackExperiment) {
                        SysdynExperimentManagerListener.this.contextActivations.add(contextService.activateContext(SysdynExperimentManagerListener.PLAYBACK_EXPERIMENT_CONTEXT));
                        experiment.addListener((IExperimentListener)new SysdynPlaybackExperimentListener((SysdynPlaybackExperiment)experiment));
                    } else if (experiment instanceof SysdynGameExperimentBase) {
                        SysdynExperimentManagerListener.this.contextActivations.add(contextService.activateContext(SysdynExperimentManagerListener.GAME_EXPERIMENT_CONTEXT));
                    } else if (experiment instanceof SysdynSensitivityAnalysisExperimentBase) {
                        SysdynExperimentManagerListener.this.contextActivations.add(contextService.activateContext(SysdynExperimentManagerListener.SENSITIVITY_ANALYSIS_EXPERIMENT_CONTEXT));
                    } else if (experiment instanceof SysdynExperiment) {
                        SysdynExperimentManagerListener.this.contextActivations.add(contextService.activateContext(SysdynExperimentManagerListener.BASIC_EXPERIMENT_CONTEXT));
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeExperimentUnloaded() {
        Collection<IContextActivation> collection = this.contextActivations;
        synchronized (collection) {
            final Collection<IContextActivation> oldContextActivations = this.contextActivations;
            this.contextActivations = new ArrayList<IContextActivation>();
            final IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (workbench.isClosing()) {
                        return;
                    }
                    IContextService contextService = (IContextService)workbench.getActiveWorkbenchWindow().getService(IContextService.class);
                    contextService.deactivateContexts(oldContextActivations);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void managerDisposed() {
        Set<IExperimentManager> set = managers;
        synchronized (set) {
            managers.remove(this.manager);
        }
    }
}

