/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements.connections;

import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;

public class Flows {
    public static double ARROW_LENGTH = 3.2;
    public static double ARROW_WIDTH = 2.0;
    static final double OFFSET = 1.0;
    static final double ARROW_OFFSET = 3.2;
    private static int x = 0;
    private static int y = 1;

    public static Path2D createArrow(Path2D arrow, Rectangle2D tail, Rectangle2D head) {
        double x = tail.getCenterX();
        double y = tail.getCenterY();
        double cx = head.getCenterX();
        double minx = head.getMinX();
        double maxx = head.getMaxX();
        double miny = head.getMinY();
        double maxy = head.getMaxY();
        if (arrow == null) {
            arrow = new Path2D.Double();
        } else {
            arrow.reset();
        }
        if (y < miny) {
            arrow.moveTo(cx, miny);
            arrow.lineTo(cx + ARROW_WIDTH, miny - ARROW_LENGTH);
            arrow.lineTo(cx - ARROW_WIDTH, miny - ARROW_LENGTH);
        } else if (y > maxy) {
            arrow.moveTo(cx, maxy);
            arrow.lineTo(cx + ARROW_WIDTH, maxy + ARROW_LENGTH);
            arrow.lineTo(cx - ARROW_WIDTH, maxy + ARROW_LENGTH);
        } else if (x < minx) {
            arrow.moveTo(minx, y);
            arrow.lineTo(minx - ARROW_LENGTH, y - ARROW_WIDTH);
            arrow.lineTo(minx - ARROW_LENGTH, y + ARROW_WIDTH);
        } else if (x > maxx) {
            arrow.moveTo(maxx, y);
            arrow.lineTo(maxx + ARROW_LENGTH, y - ARROW_WIDTH);
            arrow.lineTo(maxx + ARROW_LENGTH, y + ARROW_WIDTH);
        } else {
            return null;
        }
        arrow.closePath();
        return arrow;
    }

    private static Path2D createLines(Path2D lines, boolean vertical, double ... coordinates) {
        if (lines == null) {
            lines = new Path2D.Double();
        } else {
            lines.reset();
        }
        Flows.createOffsetLine(lines, vertical, 1.0, coordinates);
        Flows.createOffsetLine(lines, vertical, -1.0, coordinates);
        return lines;
    }

    public static Path2D createLines(Path2D lines, boolean hasArrow, Rectangle2D valve, Rectangle2D node) {
        double x0 = valve.getCenterX();
        double y0 = valve.getCenterY();
        double x1 = node.getCenterX();
        double y1 = node.getCenterY();
        double minY = hasArrow ? node.getMinY() - 3.2 : node.getMinY();
        double maxY = hasArrow ? node.getMaxY() + 3.2 : node.getMaxY();
        double minX = hasArrow ? node.getMinX() - 3.2 : node.getMinX();
        double maxX = hasArrow ? node.getMaxX() + 3.2 : node.getMaxX();
        boolean rotated = false;
        if (rotated) {
            y0 = y1 > y0 ? (y0 += 1.0) : (y0 -= 1.0);
            if (node.getMinX() <= x0 && node.getMaxX() >= x0) {
                if (y1 > y0) {
                    return Flows.createLines(lines, true, y0, x0, minY);
                }
                return Flows.createLines(lines, true, y0, x0, maxY);
            }
            if (x1 > x0) {
                return Flows.createLines(lines, true, y0, x0, y1, minX);
            }
            return Flows.createLines(lines, true, y0, x0, y1, maxX);
        }
        x0 = x1 > x0 ? (x0 += 1.0) : (x0 -= 1.0);
        if (node.getMinY() <= y0 && node.getMaxY() >= y0) {
            if (x1 > x0) {
                return Flows.createLines(lines, false, x0, y0, minX);
            }
            return Flows.createLines(lines, false, x0, y0, maxX);
        }
        if (y1 > y0) {
            return Flows.createLines(lines, false, x0, y0, x1, minY);
        }
        return Flows.createLines(lines, false, x0, y0, x1, maxY);
    }

    public static Path2D createLine(Path2D path, boolean vertical, double ... coordinates) {
        if (vertical) {
            path.moveTo(coordinates[1], coordinates[0]);
        } else {
            path.moveTo(coordinates[0], coordinates[1]);
        }
        int i = 2;
        while (i < coordinates.length) {
            if (vertical) {
                path.lineTo(coordinates[i - 1], coordinates[i]);
            } else {
                path.lineTo(coordinates[i], coordinates[i - 1]);
            }
            ++i;
            boolean bl = vertical = !vertical;
        }
        return path;
    }

    public static Path2D createOffsetLine(Path2D path, boolean vertical, double offset, double ... coordinates) {
        double[] newCoordinats = new double[coordinates.length];
        newCoordinats[0] = coordinates[0];
        newCoordinats[coordinates.length - 1] = coordinates[coordinates.length - 1];
        int i = 1;
        while (i < coordinates.length - 1) {
            newCoordinats[i] = coordinates[i - 1] < coordinates[i + 1] ^ (i & 1) == 1 ? coordinates[i] + offset : coordinates[i] - offset;
            ++i;
        }
        return Flows.createLine(path, vertical, newCoordinats);
    }

    public static Path2D createOffsetPath(Path2D originalPath, float offset) {
        PathIterator pi = originalPath.getPathIterator(null);
        Path2D.Double newPath = new Path2D.Double();
        double[] previous = new double[6];
        double[] current = new double[6];
        double[] next = new double[6];
        boolean vertical = false;
        pi.currentSegment(current);
        pi.next();
        pi.currentSegment(next);
        Direction direction = Flows.getDirection(current, next);
        int i = 0;
        if (direction == Direction.SOUTH || direction == Direction.NORTH) {
            vertical = true;
            int n = x;
            current[n] = current[n] + (double)offset;
            ((Path2D)newPath).moveTo(current[x], current[y]);
            if (direction == Direction.SOUTH) {
                offset = -offset;
            }
        } else {
            int n = y;
            current[n] = current[n] + (double)offset;
            i = 1;
            ((Path2D)newPath).moveTo(current[x], current[y]);
            if (direction == Direction.WEST) {
                offset = -offset;
            }
        }
        previous[Flows.x] = current[x];
        previous[Flows.y] = current[y];
        current[Flows.x] = next[x];
        current[Flows.y] = next[y];
        while (!pi.isDone()) {
            pi.next();
            pi.currentSegment(next);
            if (previous[i] < next[i] ^ (i & 1) == 1) {
                if (vertical) {
                    if (!pi.isDone()) {
                        int n = y;
                        current[n] = current[n] + (double)offset;
                    }
                    ((Path2D)newPath).lineTo(previous[x], current[y]);
                } else {
                    if (!pi.isDone()) {
                        int n = x;
                        current[n] = current[n] + (double)offset;
                    }
                    ((Path2D)newPath).lineTo(current[x], previous[y]);
                }
            } else if (vertical) {
                if (!pi.isDone()) {
                    int n = y;
                    current[n] = current[n] - (double)offset;
                }
                ((Path2D)newPath).lineTo(previous[x], current[y]);
            } else {
                if (!pi.isDone()) {
                    int n = x;
                    current[n] = current[n] - (double)offset;
                }
                ((Path2D)newPath).lineTo(current[x], previous[y]);
            }
            previous[Flows.x] = current[x];
            previous[Flows.y] = current[y];
            current[Flows.x] = next[x];
            current[Flows.y] = next[y];
            vertical = !vertical;
            i = (i + 1) % 2;
        }
        return newPath;
    }

    private static Direction getDirection(double[] current, double[] next) {
        if (current[x] == next[x]) {
            if (current[y] < next[y]) {
                return Direction.SOUTH;
            }
            return Direction.NORTH;
        }
        if (current[x] < next[x]) {
            return Direction.EAST;
        }
        return Direction.WEST;
    }

    private static enum Direction {
        NORTH,
        SOUTH,
        EAST,
        WEST;

    }
}

