/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.sysdyn.ui.elements.SysdynTextNode;

public class ModuleNode
extends SysdynTextNode {
    private static final long serialVersionUID = 8535695797227320496L;
    private static double CORNER_LENGTH = 2.0;
    private static double CORNER_PADDING = 0.8;

    public void render(Graphics2D g) {
        super.render(g);
        BasicStroke oldStroke = (BasicStroke)g.getStroke();
        Color oldColor = g.getColor();
        Rectangle2D bounds = this.getBounds();
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(bounds.getMinX() + CORNER_LENGTH, bounds.getMinY() - CORNER_PADDING);
        ((Path2D)path).lineTo(bounds.getMinX() - CORNER_PADDING, bounds.getMinY() - CORNER_PADDING);
        ((Path2D)path).lineTo(bounds.getMinX() - CORNER_PADDING, bounds.getMinY() + CORNER_LENGTH);
        ((Path2D)path).moveTo(bounds.getMinX() + CORNER_LENGTH, bounds.getMaxY() + CORNER_PADDING);
        ((Path2D)path).lineTo(bounds.getMinX() - CORNER_PADDING, bounds.getMaxY() + CORNER_PADDING);
        ((Path2D)path).lineTo(bounds.getMinX() - CORNER_PADDING, bounds.getMaxY() - CORNER_LENGTH);
        ((Path2D)path).moveTo(bounds.getMaxX() - CORNER_LENGTH, bounds.getMinY() - CORNER_PADDING);
        ((Path2D)path).lineTo(bounds.getMaxX() + CORNER_PADDING, bounds.getMinY() - CORNER_PADDING);
        ((Path2D)path).lineTo(bounds.getMaxX() + CORNER_PADDING, bounds.getMinY() + CORNER_LENGTH);
        ((Path2D)path).moveTo(bounds.getMaxX() - CORNER_LENGTH, bounds.getMaxY() + CORNER_PADDING);
        ((Path2D)path).lineTo(bounds.getMaxX() + CORNER_PADDING, bounds.getMaxY() + CORNER_PADDING);
        ((Path2D)path).lineTo(bounds.getMaxX() + CORNER_PADDING, bounds.getMaxY() - CORNER_LENGTH);
        g.setStroke(new BasicStroke((float)(this.scale * (double)this.borderWidth)));
        g.setColor(this.borderColor);
        g.draw(path);
        boolean selected = NodeUtil.isSelected((INode)this, (int)1);
        if (selected && this.showsSelection()) {
            Composite oc = g.getComposite();
            g.setComposite(AlphaComposite.SrcOver.derive(0.5f));
            g.setColor(Color.RED);
            float bw = this.borderWidth;
            double s = GeometryUtils.getScale((AffineTransform)g.getTransform());
            bw = bw <= 0.0f ? (float)(1.0 / s) : (float)((double)bw * (3.0 * this.scale));
            g.setStroke(new BasicStroke(bw));
            g.draw(path);
            g.setComposite(oc);
        }
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }
}

