/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.simantics.Simantics;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.AdaptionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.operation.Layer0X;
import org.simantics.ui.icons.ImageDescriptorProvider;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.ui.workbench.ResourceEditorInputFactory2;
import org.simantics.ui.workbench.TitleRequest;
import org.simantics.ui.workbench.ToolTipRequest;
import org.simantics.utils.ObjectUtils;
import org.simantics.utils.datastructures.cache.ProvisionException;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.StringMemento;

public class SysdynEditorInput
extends ResourceEditorInput2 {
    private static final boolean DEBUG_UPDATE = false;
    private static final String NO_NAME = "(no name)";
    private final String editorID;
    private String randomAccessResourceId;
    private transient Resource resource;
    private transient Session session;
    private transient boolean exists;
    private transient String name;
    private transient String tooltip;
    private transient ImageDescriptor imageDesc;
    private final StringMemento persistentStore = new StringMemento();

    public SysdynEditorInput(String editorID, Resource r, Resource model, String rvi) {
        super(editorID, r, model, rvi);
        if (editorID == null) {
            throw new IllegalArgumentException("null editor id");
        }
        if (r == null) {
            throw new IllegalArgumentException("null resource");
        }
        this.editorID = editorID;
        this.randomAccessResourceId = "";
        this.resource = r;
        this.rvi = rvi;
        this.session = Simantics.getSession();
        this.ensureRandomAccessId();
        this.setNonExistant();
    }

    void ensureRandomAccessId() {
        if (this.resource == null) {
            throw new IllegalStateException("resource is null, input is disposed");
        }
        try {
            SerialisationSupport support = (SerialisationSupport)this.session.getService(SerialisationSupport.class);
            this.randomAccessResourceId = String.valueOf(support.getRandomAccessId(this.resource));
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    public void init(IAdaptable adapter) throws DatabaseException {
        if (this.resource == null && this.randomAccessResourceId != null) {
            this.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph g) throws DatabaseException {
                    try {
                        long id = Long.parseLong(SysdynEditorInput.this.randomAccessResourceId);
                        SysdynEditorInput.this.resource = ((SerialisationSupport)g.getService(SerialisationSupport.class)).getResource(id);
                        SysdynEditorInput.this.update(g);
                    }
                    catch (NumberFormatException e) {
                        SysdynEditorInput.this.setNonExistant();
                    }
                    catch (DatabaseException e) {
                        SysdynEditorInput.this.setNonExistant();
                    }
                }
            });
        } else if (this.resource != null) {
            this.updateCaches((AsyncRequestProcessor)this.getSession(), true);
        }
    }

    public void dispose() {
        this.session = null;
        this.resource = null;
    }

    public Session getSession() {
        if (this.session == null) {
            throw new IllegalStateException("session is disposed");
        }
        return this.session;
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean exists(ReadGraph graph) throws DatabaseException {
        try {
            this.assertExists(graph);
            return true;
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
        }
        catch (Nonexistant nonexistant) {
            // empty catch block
        }
        return false;
    }

    public Resource getResource() {
        return this.resource;
    }

    @Deprecated
    public ResourceArray getResourceArray() {
        return new ResourceArray(new Resource[]{this.resource});
    }

    public String getRVI() {
        return this.rvi;
    }

    public ImageDescriptor getImageDescriptor() {
        return this.imageDesc;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTipText() {
        return this.tooltip;
    }

    public IPersistableElement getPersistable() {
        if (!this.isPersistable()) {
            return null;
        }
        return this;
    }

    protected boolean isPersistable() {
        if (this.session == null) {
            return false;
        }
        LifecycleSupport lc = (LifecycleSupport)this.session.peekService(LifecycleSupport.class);
        if (lc == null) {
            return false;
        }
        return !lc.isClosed();
    }

    public String getFactoryId() {
        return ResourceEditorInputFactory2.getFactoryId();
    }

    public void saveState(IMemento memento) {
        if (this.randomAccessResourceId == null) {
            this.ensureRandomAccessId();
        }
        IMemento child = memento.createChild("resourceId");
        child.putTextData(this.randomAccessResourceId);
        memento.putString("editorId", this.editorID);
        memento.putString("modelId", this.modelId);
        memento.putString("rvi", this.rvi);
        memento.putString("external", this.persistentStore.toString());
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.editorID.hashCode();
        result = 31 * result + ObjectUtils.hashCode((Object)this.modelId);
        result = 31 * result + ObjectUtils.hashCode((Object)this.rvi);
        result = 31 * result + ObjectUtils.hashCode((Object)this.randomAccessResourceId);
        return result;
    }

    private void updateCaches(AsyncRequestProcessor processor, boolean sync) throws DatabaseException {
        ReadRequest req = new ReadRequest(){

            public void run(ReadGraph g) throws DatabaseException {
                SysdynEditorInput.this.update(g);
            }
        };
        if (sync) {
            processor.getSession().syncRequest((Read)req);
        } else {
            processor.asyncRequest((Read)req);
        }
    }

    public void update(ReadGraph g) throws DatabaseException {
        Resource r = this.getResource();
        if (r == null) {
            return;
        }
        try {
            this.assertExists(g);
            this.name = (String)g.syncRequest((Read)new TitleRequest(this.editorID, (IResourceEditorInput)this));
            if (this.name == null) {
                this.name = NO_NAME;
            }
            this.tooltip = (String)g.syncRequest((Read)new ToolTipRequest(this.editorID, (IResourceEditorInput)this));
            if (this.tooltip == null) {
                this.tooltip = NO_NAME;
            }
            try {
                ImageDescriptorProvider idp = (ImageDescriptorProvider)g.adapt(r, ImageDescriptorProvider.class);
                this.imageDesc = (ImageDescriptor)idp.get();
            }
            catch (AdaptionException e) {
                this.imageDesc = ImageDescriptor.getMissingImageDescriptor();
            }
            catch (ProvisionException e) {
                this.imageDesc = ImageDescriptor.getMissingImageDescriptor();
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
        catch (DatabaseException e) {
            this.setNonExistant();
        }
    }

    private void assertExists(ReadGraph g) throws DatabaseException {
        Resource r = this.getResource();
        if (r == null) {
            throw new Nonexistant();
        }
        boolean exists = g.hasStatement(r);
        if (!exists) {
            throw new Nonexistant();
        }
        if (this.getModel(g) != null && g.getPossibleURI(this.getModel(g)) != null) {
            Layer0X L0X = Layer0X.getInstance((ReadGraph)g);
            Resource model = this.getModel(g);
            Resource baseRealization = g.getPossibleObject(model, L0X.HasBaseRealization);
            Variable modelVariable = Variables.getVariable((ReadGraph)g, (String)g.getURI(baseRealization));
            modelVariable.browse(g, this.getRVI());
        }
        g.syncRequest((Read)new TitleRequest(this.editorID, (IResourceEditorInput)this));
    }

    private void setNonExistant() {
        this.exists = false;
        this.name = NO_NAME;
        this.tooltip = NO_NAME;
        this.imageDesc = ImageDescriptor.getMissingImageDescriptor();
    }

    public IMemento getPersistentStore() {
        return this.persistentStore;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + " [name=" + this.getName() + ", resource=" + this.resource + "]";
    }

    static class Nonexistant
    extends DatabaseException {
        private static final long serialVersionUID = -7964385375237203651L;

        Nonexistant() {
        }

        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

