/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodes;

import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.common.node.IDoubleClickableNode;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.ui.utils.SheetNameValidator;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class SheetNode
extends AbstractNode<Resource>
implements IModifiableNode,
IDoubleClickableNode {
    public SheetNode(Resource data) {
        super((Object)data);
    }

    public Labeler.Modifier getModifier(String columnId) {
        Session session = Simantics.getSession();
        LabelModifier modifier = new LabelModifier(session, (Resource)this.data, ((Layer0)session.getService(Layer0.class)).HasName){

            public String isValid(String label) {
                if (!new SheetNameValidator().isValid((Resource)SheetNode.this.data, label)) {
                    return "Not valid";
                }
                return null;
            }
        };
        return modifier;
    }

    public boolean handleDoubleClick() {
        try {
            Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Variable variable = (Variable)graph.adapt((Resource)SheetNode.this.data, Variable.class);
                    final Resource model = Variables.getModel((ReadGraph)graph, (Variable)variable);
                    final RVI rvi = variable.getRVI(graph);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){
                        private static final String EDITOR_ID = "org.simantics.spreadsheet.ui.editor2";

                        @Override
                        public void run() {
                            try {
                                System.out.println("Activating sheet: model=" + model + " rvi=" + rvi);
                                WorkbenchUtils.openEditor((String)EDITOR_ID, (IEditorInput)new ResourceEditorInput2(EDITOR_ID, (Resource)(this).SheetNode.this.data, model, rvi));
                            }
                            catch (PartInitException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }
}

