/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.contributions;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.browsing.ui.graph.contributor.viewpoint.ViewpointContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.browser.nodes.AbstractChartNode;
import org.simantics.sysdyn.ui.browser.nodes.BarChartNode;
import org.simantics.sysdyn.ui.browser.nodes.ChartsFolder;
import org.simantics.sysdyn.ui.browser.nodes.LineChartNode;
import org.simantics.sysdyn.ui.browser.nodes.PieChartNode;
import org.simantics.sysdyn.ui.browser.nodes.SensitivityChartNode;

public class Charts
extends ViewpointContributor<ChartsFolder> {
    public Collection<?> getContribution(ReadGraph graph, ChartsFolder folder) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        JFreeChartResource JFREE = JFreeChartResource.getInstance((ReadGraph)graph);
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        ArrayList<AbstractChartNode> result = new ArrayList<AbstractChartNode>();
        for (Resource chart : (Collection)graph.syncRequest((Read)new ObjectsWithType((Resource)folder.data, L0.ConsistsOf, JFREE.Chart))) {
            Resource plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(chart, L0.ConsistsOf, JFREE.Plot));
            if (plot == null) continue;
            if (graph.isInstanceOf(plot, SR.Charts_SensitivityPlot)) {
                result.add(new SensitivityChartNode(chart));
                continue;
            }
            if (graph.isInstanceOf(plot, JFREE.XYPlot)) {
                result.add(new LineChartNode(chart));
                continue;
            }
            if (graph.isInstanceOf(plot, JFREE.CategoryPlot)) {
                result.add(new BarChartNode(chart));
                continue;
            }
            if (!graph.isInstanceOf(plot, JFREE.PiePlot)) continue;
            result.add(new PieChartNode(chart));
        }
        return result;
    }
}

