/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.actions;

import java.util.Set;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.browser.BrowserSelection;
import org.simantics.sysdyn.ui.browser.nodes.ModuleNode;
import org.simantics.sysdyn.ui.editor.SysdynEditorInput;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.IDoubleClickAction;
import org.simantics.ui.workbench.ResourceEditorInput2;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.action.IPriorityAction;
import org.simantics.utils.ui.action.PriorityAction;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ShowInstantiatedModuleAction
implements IDoubleClickAction {
    private static final String EDITOR_ID = "org.simantics.sysdyn.ui.diagramViewer";

    public void doubleClickEvent(DoubleClickEvent e) throws DatabaseException {
        Resource represents;
        Resource instanceOf;
        Resource configuration;
        ReadGraph g = e.getGraph();
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        StructuralResource2 sr2 = StructuralResource2.getInstance((ReadGraph)g);
        Variable variable = (Variable)AdaptionUtils.adaptToSingle((Object)e.getResource(), Variable.class);
        if (variable != null && (configuration = g.getPossibleObject(instanceOf = g.getPossibleObject(represents = variable.getRepresents(g), l0.InstanceOf), sr2.IsDefinedBy)) != null) {
            String rvi = Variables.getRVI((ReadGraph)g, (Variable)variable);
            if (!rvi.isEmpty()) {
                rvi = rvi.substring(1);
            }
            Resource model = Variables.getModel((ReadGraph)g, (Variable)variable);
            this.addShowModuleAction(e, this.getResourceEditorInput(g, model, configuration, rvi));
            return;
        }
        if (e.getResource() instanceof IStructuredSelection) {
            Set bss = ISelectionUtils.filterSetSelection((Object)e.getResource(), BrowserSelection.class);
            if (!bss.isEmpty()) {
                for (BrowserSelection bs : bss) {
                    Resource configuration2 = bs.getAdapter(Resource.class);
                    Resource instanceOf2 = g.getSingleObject(configuration2, l0.InstanceOf);
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
                    if (!g.isInheritedFrom(instanceOf2, sr.Module)) continue;
                    configuration2 = g.getSingleObject(instanceOf2, sr2.IsDefinedBy);
                    variable = bs.getAdapter(Variable.class);
                    String rvi = Variables.getRVI((ReadGraph)g, (Variable)variable).substring(1);
                    Resource model = Variables.getModel((ReadGraph)g, (Variable)variable);
                    this.addShowModuleAction(e, this.getResourceEditorInput(g, model, configuration2, rvi));
                }
            } else {
                ModuleNode moduleNode = (ModuleNode)((Object)ISelectionUtils.filterSingleSelection((Object)e.getResource(), ModuleNode.class));
                if (moduleNode != null) {
                    String rvi;
                    Resource model;
                    if (moduleNode.getVariable() != null) {
                        model = Variables.getModel((ReadGraph)g, (Variable)moduleNode.getVariable());
                        Variable var = moduleNode.getVariable();
                        rvi = Variables.getRVI((ReadGraph)g, (Variable)var).substring(1);
                    } else {
                        rvi = (String)g.getRelatedValue((Resource)moduleNode.data, Layer0.getInstance((ReadGraph)g).HasName);
                        model = g.getSingleObject((Resource)moduleNode.data, l0.PartOf);
                    }
                    Resource instanceOf3 = g.getSingleObject((Resource)moduleNode.data, l0.InstanceOf);
                    Resource conf = g.getSingleObject(instanceOf3, sr2.IsDefinedBy);
                    this.addShowModuleAction(e, this.getResourceEditorInput(g, model, conf, rvi));
                }
            }
        }
    }

    private ResourceEditorInput2 getResourceEditorInput(ReadGraph g, Resource model, Resource configuration, String rvi) throws DatabaseException {
        if (model == null) {
            model = (Resource)g.syncRequest((Read)new PossibleModel(model));
            rvi = null;
        }
        Resource diagram = g.getSingleObject(configuration, ModelingResources.getInstance((ReadGraph)g).CompositeToDiagram);
        return new SysdynEditorInput(EDITOR_ID, diagram, model, rvi == null ? "" : "/" + rvi);
    }

    private void addShowModuleAction(DoubleClickEvent e, final ResourceEditorInput2 editorInput) {
        e.add((IPriorityAction)new PriorityAction(1000){

            public void run() {
                try {
                    WorkbenchUtils.openEditor((String)ShowInstantiatedModuleAction.EDITOR_ID, (IEditorInput)editorInput);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        });
        e.consume();
    }
}

