/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.IFunction;
import org.simantics.objmap.IMappingRule;
import org.simantics.objmap.MappingException;
import org.simantics.objmap.rules.factory.IMethodRuleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateMethodFactory
implements IMethodRuleFactory {
    static Logger LOGGER = LoggerFactory.getLogger((String)"org.simantics.objmap");

    @Override
    public IMappingRule create(ReadGraph g, Annotation annotation, final Method method) throws DatabaseException {
        method.setAccessible(true);
        return new IMappingRule(){

            @Override
            public boolean updateRange(ReadGraph g, IFunction<Resource, Object> map, Resource domainElement, Object rangeElement) throws MappingException {
                LOGGER.trace("    UpdateMethodFactory.updateRange");
                try {
                    return (Boolean)method.invoke(rangeElement, g, domainElement);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

            @Override
            public boolean updateDomain(WriteGraph g, IFunction<Object, Resource> map, Resource domainElement, Object rangeElement) throws MappingException {
                return false;
            }
        };
    }
}

