/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modelica.data;

public class DataSet {
    public String name;
    public double[] times;
    public double[] values;

    public DataSet(String name, double[] times, double[] values) {
        this.name = name;
        this.times = times;
        this.values = values;
    }

    public void filter(double startTime, double stopTime, double timeStep) {
        int size = (int)Math.round((stopTime - startTime) / timeStep) + 1;
        if (this.times.length < size) {
            return;
        }
        double[] newTimes = new double[size];
        double[] newValues = new double[size];
        double epsilon = timeStep / 1000.0;
        int old = 0;
        int i = 0;
        while (i < size) {
            newTimes[i] = startTime + (double)i * timeStep;
            while (this.times[old] < newTimes[i] - epsilon && old != this.times.length - 1) {
                ++old;
            }
            newValues[i] = this.values[old];
            ++i;
        }
        this.times = newTimes;
        this.values = newValues;
    }
}

