/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modelica;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class InitWriter {
    public static boolean writeXML(String file, HashMap<String, String> inits) {
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(file));
            XPath xpath = XPathFactory.newInstance().newXPath();
            for (String name : inits.keySet()) {
                NodeList nodes = null;
                try {
                    nodes = (NodeList)xpath.evaluate("//fmiModelDescription/ModelVariables/ScalarVariable[@name='" + name + "']/Real/@start", doc, XPathConstants.NODESET);
                    if (nodes.getLength() == 0) {
                        nodes = (NodeList)xpath.evaluate("//fmiModelDescription/DefaultExperiment/@" + name, doc, XPathConstants.NODESET);
                    }
                }
                catch (XPathExpressionException xPathExpressionException) {
                    // empty catch block
                }
                if (nodes == null) continue;
                int idx = 0;
                while (idx < nodes.getLength()) {
                    Node n = nodes.item(idx);
                    n.setNodeValue(inits.get(name).replaceAll("\"", ""));
                    ++idx;
                }
            }
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(new DOMSource(doc), new StreamResult(new File(file)));
            return true;
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean writeTXT(String file, HashMap<String, String> inits) {
        HashMap<String, String> initials = new HashMap<String, String>();
        HashMap<Integer, String> order = new HashMap<Integer, String>();
        try {
            String key;
            FileInputStream is = new FileInputStream(file);
            int orderNumber = 0;
            while (true) {
                String line;
                if ((line = InitWriter.getLine(is)) == null) {
                    return false;
                }
                if (line.isEmpty()) break;
                if (line.contains("//")) {
                    String[] nn = line.split("//", 2);
                    key = nn[1].trim();
                    String value = nn[0].trim();
                    if (inits.containsKey(key)) {
                        value = inits.get(key);
                    }
                    initials.put(key, value);
                    order.put(orderNumber, key);
                }
                ++orderNumber;
            }
            ((InputStream)is).close();
            PrintStream s = new PrintStream(file);
            int j = 0;
            while (j < orderNumber) {
                key = (String)order.get(j);
                if (key != null) {
                    s.println(String.valueOf((String)initials.get(key)) + " // " + key);
                } else {
                    s.println("0.0");
                }
                ++j;
            }
            s.close();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static String getLine(InputStream stream) {
        if (stream == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        try {
            while (true) {
                int c;
                if ((c = stream.read()) == -1) {
                    stream = null;
                    return b.toString();
                }
                if (c == 10) {
                    return b.toString();
                }
                if (c == 13) continue;
                b.append((char)c);
            }
        }
        catch (IOException e) {
            return null;
        }
    }
}

