/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties.pie;

import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.SingleSelectionInputSource;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.ChartUtils;
import org.simantics.jfreechart.chart.properties.AdjustableTab;
import org.simantics.jfreechart.chart.properties.pie.PieSeriesPropertyComposite;
import org.simantics.jfreechart.chart.properties.xyline.AxisAndVariablesExplorerComposite;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.ui.AdaptionUtils;

public class PieSeriesTab
extends AdjustableTab
implements Widget {
    private GraphExplorerComposite explorer;
    private ScrolledComposite propertyContainer;
    private WidgetSupportImpl additionalSupport = new WidgetSupportImpl();
    private Button add;
    private Button remove;
    private Resource chartResource;
    private int options;
    private Composite buttonComposite;

    public PieSeriesTab(Object id, int options) {
        super(id);
        this.options = options;
    }

    private void updateSelection(ISessionContext context) {
        ISelectionProvider selectionProvider = (ISelectionProvider)this.explorer.getAdapter(ISelectionProvider.class);
        IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
        Resource resource = (Resource)AdaptionUtils.adaptToSingle((Object)selection, Resource.class);
        if (resource == null) {
            return;
        }
        Control[] controlArray = this.propertyContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        PieSeriesPropertyComposite spc = new PieSeriesPropertyComposite((Composite)this.propertyContainer, context, (WidgetSupport)this.additionalSupport, this.options, 0);
        this.propertyContainer.setContent((Control)spc);
        Point size = spc.computeSize(-1, -1);
        this.propertyContainer.setMinSize(size);
        this.additionalSupport.fireInput(context, (Object)selection);
    }

    public void setInput(ISessionContext context, Object input) {
        this.chartResource = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
    }

    @Override
    protected void createAndAddControls(Composite body, IWorkbenchSite site, final ISessionContext context, WidgetSupport support) {
        support.register((Widget)this);
        this.composite = new Composite(body, 0);
        this.explorer = new AxisAndVariablesExplorerComposite((Map<String, Object>)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), site, this.composite, support, 67588);
        this.explorer.setBrowseContexts(new String[]{"http://www.simantics.org/JFreeChart-1.0/PieSeriesBrowseContext"});
        this.explorer.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(Resource.class));
        this.explorer.getExplorer().setAutoExpandLevel(2);
        this.explorer.finish();
        ((Tree)this.explorer.getExplorerControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PieSeriesTab.this.updateSelection(context);
            }
        });
        this.propertyContainer = new ScrolledComposite(this.composite, 768);
        this.propertyContainer.setExpandHorizontal(true);
        this.propertyContainer.setExpandVertical(true);
        this.buttonComposite = new Composite(this.composite, 0);
        this.add = new Button(this.buttonComposite, (WidgetSupport)this.additionalSupport, 0);
        this.add.setText("Add");
        this.add.addSelectionListener((SelectionListener)new NewVariableListener(context));
        this.remove = new Button(this.buttonComposite, (WidgetSupport)this.additionalSupport, 0);
        this.remove.setText("Remove");
        this.remove.addSelectionListener((SelectionListener)new RemoveListener(context));
    }

    @Override
    protected void createControlLayoutVertical() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().hint(150, 200).grab(false, true).applyTo((Control)this.explorer);
        GridDataFactory.fillDefaults().hint(150, 190).span(1, 1).grab(true, false).applyTo((Control)this.propertyContainer);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.propertyContainer);
        GridDataFactory.fillDefaults().applyTo((Control)this.buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.buttonComposite);
    }

    @Override
    protected void createControlLayoutHorizontal(boolean wideScreen) {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.composite);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(3, 3).applyTo(this.composite);
        GridDataFactory.fillDefaults().hint(250, -1).grab(false, true).applyTo((Control)this.explorer);
        GridDataFactory.fillDefaults().span(1, 2).grab(true, true).applyTo((Control)this.propertyContainer);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.propertyContainer);
        GridDataFactory.fillDefaults().applyTo((Control)this.buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(this.buttonComposite);
    }

    private class NewVariableListener
    extends SelectionListenerImpl<Resource> {
        public NewVariableListener(ISessionContext context) {
            super(context);
        }

        public void apply(WriteGraph graph, Resource input) throws DatabaseException {
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Resource dataset = null;
            if (input == null) {
                Resource plot;
                if (PieSeriesTab.this.chartResource != null && (plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(PieSeriesTab.this.chartResource, l0.ConsistsOf, jfree.Plot))) != null) {
                    dataset = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(plot, l0.ConsistsOf, jfree.Dataset));
                }
            } else if (graph.isInstanceOf(input, jfree.Series)) {
                dataset = graph.getPossibleObject(input, l0.PartOf);
            }
            if (dataset != null) {
                Resource series = ChartUtils.createSeries(graph, dataset, null);
                graph.claimLiteral(series, jfree.Series_exploded, (Object)false);
            }
        }
    }

    private class RemoveListener
    extends SelectionListenerImpl<Resource> {
        public RemoveListener(ISessionContext context) {
            super(context);
        }

        public void apply(WriteGraph graph, Resource input) throws DatabaseException {
            if (input == null) {
                return;
            }
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Resource list = null;
            if (graph.isInstanceOf(input, jfree.Series)) {
                Resource dataset = graph.getPossibleObject(input, l0.PartOf);
                if (dataset != null) {
                    list = graph.getPossibleObject(dataset, jfree.Dataset_seriesList);
                }
                if (list != null) {
                    ListUtils.removeElement((WriteGraph)graph, (Resource)list, (Resource)input);
                }
                RemoverUtil.remove((WriteGraph)graph, (Resource)input);
            }
        }
    }
}

