/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties.bar;

import java.util.Collection;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.browsing.ui.swt.SingleSelectionInputSource;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupportImpl;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.jfreechart.chart.ChartUtils;
import org.simantics.jfreechart.chart.properties.AllVariablesOfModel;
import org.simantics.jfreechart.chart.properties.LabelPropertyTabContributor;
import org.simantics.jfreechart.chart.properties.bar.BarSeriesPropertyComposite2;
import org.simantics.jfreechart.chart.properties.xyline.AxisAndVariablesExplorerComposite;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ExceptionUtils;

public class BarSeriesTab2
extends LabelPropertyTabContributor
implements Widget {
    private GraphExplorerComposite explorer;
    private ScrolledComposite propertyContainer;
    private WidgetSupportImpl additionalSupport = new WidgetSupportImpl();
    private Button add;
    private Button remove;
    private Resource chartResource;
    private BarSeriesPropertyComposite2 spc;
    private int options;

    public BarSeriesTab2(Object id, int options) {
        super(id);
        this.options = options;
    }

    public void createControls(Composite body, IWorkbenchSite site, final ISessionContext context, WidgetSupport support) {
        support.register((Widget)this);
        Composite composite = new Composite(body, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(3, 3).applyTo(composite);
        this.explorer = new AxisAndVariablesExplorerComposite((Map<String, Object>)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), site, composite, support, 67588);
        this.explorer.setBrowseContexts(new String[]{"http://www.simantics.org/JFreeChart-1.0/BarSeriesBrowseContext"});
        this.explorer.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(Resource.class));
        this.explorer.getExplorer().setAutoExpandLevel(2);
        this.explorer.finish();
        ((Tree)this.explorer.getExplorerControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BarSeriesTab2.this.updateSelection(context);
            }
        });
        GridDataFactory.fillDefaults().hint(250, -1).grab(false, true).applyTo((Control)this.explorer);
        this.propertyContainer = new ScrolledComposite(composite, 768);
        GridDataFactory.fillDefaults().span(1, 2).grab(true, true).applyTo((Control)this.propertyContainer);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.propertyContainer);
        this.propertyContainer.setExpandHorizontal(true);
        this.propertyContainer.setExpandVertical(true);
        Composite buttonComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(buttonComposite);
        this.add = new Button(buttonComposite, (WidgetSupport)this.additionalSupport, 0);
        this.add.setText("Add");
        this.add.addSelectionListener((SelectionListener)new NewVariableListener(context));
        this.remove = new Button(buttonComposite, (WidgetSupport)this.additionalSupport, 0);
        this.remove.setText("Remove");
        this.remove.addSelectionListener((SelectionListener)new RemoveListener(context));
    }

    private void updateSelection(ISessionContext context) {
        ISelectionProvider selectionProvider = (ISelectionProvider)this.explorer.getAdapter(ISelectionProvider.class);
        IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
        Resource resource = (Resource)AdaptionUtils.adaptToSingle((Object)selection, Resource.class);
        if (resource == null) {
            return;
        }
        Control[] controlArray = this.propertyContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        try {
            AllVariablesOfModel query = AllVariablesOfModel.withRandomResource(context, resource);
            Collection variables = (Collection)context.getSession().syncRequest((Read)query);
            this.spc = new BarSeriesPropertyComposite2((Composite)this.propertyContainer, context, (WidgetSupport)this.additionalSupport, variables, this.options, 0);
            this.additionalSupport.fireInput(context, (Object)selection);
            this.propertyContainer.setContent((Control)this.spc);
            Point size = this.spc.computeSize(-1, -1);
            this.propertyContainer.setMinSize(size);
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
    }

    public void setInput(ISessionContext context, Object input) {
        this.chartResource = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
    }

    private class NewVariableListener
    extends SelectionListenerImpl<Resource> {
        public NewVariableListener(ISessionContext context) {
            super(context);
        }

        public void apply(WriteGraph graph, Resource input) throws DatabaseException {
            Resource dataset = null;
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            if (input == null) {
                Resource plot;
                if (BarSeriesTab2.this.chartResource != null && (plot = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(BarSeriesTab2.this.chartResource, l0.ConsistsOf, jfree.Plot))) != null) {
                    dataset = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(plot, l0.ConsistsOf, jfree.Dataset));
                }
            } else if (graph.isInstanceOf(input, jfree.Series)) {
                dataset = graph.getPossibleObject(input, l0.PartOf);
            }
            if (dataset != null) {
                ChartUtils.createSeries(graph, dataset, null);
            }
        }
    }

    private class RemoveListener
    extends SelectionListenerImpl<Resource> {
        public RemoveListener(ISessionContext context) {
            super(context);
        }

        public void apply(WriteGraph graph, Resource input) throws DatabaseException {
            if (input == null) {
                return;
            }
            JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
            Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
            Resource list = null;
            if (graph.isInstanceOf(input, jfree.Series)) {
                Resource dataset = graph.getPossibleObject(input, l0.PartOf);
                if (dataset != null) {
                    list = graph.getPossibleObject(dataset, jfree.Dataset_seriesList);
                }
                if (list != null) {
                    ListUtils.removeElement((WriteGraph)graph, (Resource)list, (Resource)input);
                }
                RemoverUtil.remove((WriteGraph)graph, (Resource)input);
            }
        }
    }
}

