/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.ge;

import java.util.List;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.ui.AdaptionUtils;

public class AxisDropAction
implements DropActionFactory {
    public Runnable create(ReadGraph g, Object target, Object source, int operation) throws DatabaseException {
        Resource t = (Resource)AdaptionUtils.adaptToSingle((Object)target, Resource.class);
        Resource s = (Resource)AdaptionUtils.adaptToSingle((Object)source, Resource.class);
        if (t == null || s == null) {
            return null;
        }
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)g);
        if (!g.isInstanceOf(s, jfree.Axis)) {
            return null;
        }
        if (!g.isInstanceOf(t, jfree.Series) && !g.isInstanceOf(t, jfree.Axis)) {
            return null;
        }
        return this.getRunnable(t, s);
    }

    private Runnable getRunnable(final Resource t, final Resource s) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        if (t == null || s == null) {
                            return;
                        }
                        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        Resource target = t;
                        Resource source = s;
                        Resource plot = graph.getPossibleObject(source, l0.PartOf);
                        Resource axisListResource = graph.getPossibleObject(plot, jfree.Plot_rangeAxisList);
                        List axisList = ListUtils.toList((ReadGraph)graph, (Resource)axisListResource);
                        if (graph.isInstanceOf(target, jfree.Series)) {
                            Resource dataset = graph.getPossibleObject(target, l0.PartOf);
                            target = graph.getPossibleObject(dataset, jfree.Dataset_mapToRangeAxis);
                        }
                        int targetIndex = axisList.indexOf(target);
                        axisList.remove(source);
                        axisList.add(targetIndex, source);
                        graph.deny(plot, jfree.Plot_rangeAxisList);
                        axisListResource = ListUtils.create((WriteGraph)graph, (Iterable)axisList);
                        graph.claim(plot, jfree.Plot_rangeAxisList, axisListResource);
                    }
                });
            }
        };
        return runnable;
    }
}

