/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import java.awt.Color;
import java.util.ArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.diagram.G2DUtils;
import org.simantics.jfreechart.chart.ConstantXYDatasetSeries;
import org.simantics.jfreechart.chart.IRenderer;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.datastructures.Pair;

public class ConstantXYDatasetRequest
implements Read<Pair<ArrayList<ConstantXYDatasetSeries>, IRenderer>> {
    protected Resource dataset;

    public ConstantXYDatasetRequest(Resource dataset) {
        this.dataset = dataset;
    }

    public Pair<ArrayList<ConstantXYDatasetSeries>, IRenderer> perform(ReadGraph graph) throws DatabaseException {
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)graph);
        IRenderer renderer = null;
        Resource rendererResource = graph.getPossibleObject(this.dataset, jfree.Dataset_renderer);
        if (rendererResource != null) {
            renderer = (IRenderer)graph.adapt(rendererResource, IRenderer.class);
        }
        ArrayList<ConstantXYDatasetSeries> series = new ArrayList<ConstantXYDatasetSeries>();
        Resource seriesList = graph.getPossibleObject(this.dataset, jfree.Dataset_seriesList);
        if (seriesList != null) {
            for (Resource r : ListUtils.toList((ReadGraph)graph, (Resource)seriesList)) {
                Resource c;
                double[] xData = (double[])graph.getPossibleRelatedValue(r, jfree.ConstantSeries_xData, (Binding)Bindings.DOUBLE_ARRAY);
                double[] yData = (double[])graph.getPossibleRelatedValue(r, jfree.ConstantSeries_yData, (Binding)Bindings.DOUBLE_ARRAY);
                Integer width = (Integer)graph.getPossibleRelatedValue(r, jfree.Series_lineWidth, (Binding)Bindings.INTEGER);
                if (width == null) {
                    width = 1;
                }
                Color color = (c = graph.getPossibleObject(r, jfree.color)) == null ? null : G2DUtils.getColor((ReadGraph)graph, (Resource)c);
                String label = (String)graph.getPossibleRelatedValue(r, Layer0.getInstance((ReadGraph)graph).HasName);
                if (xData == null || yData == null || xData.length != yData.length) continue;
                String name = label;
                if (xData.length == 0 || yData.length == 0) continue;
                ConstantXYDatasetSeries tempSeries = new ConstantXYDatasetSeries(name, new double[][]{xData, yData}, width, color);
                series.add(tempSeries);
            }
        }
        return new Pair(series, (Object)renderer);
    }
}

