/*
 * Decompiled with CFR 0.152.
 */
package fi.semantum.sysdyn.solver;

import fi.semantum.sysdyn.solver.IEnvironment;
import fi.semantum.sysdyn.solver.IExpression;
import fi.semantum.sysdyn.solver.IFrame;
import fi.semantum.sysdyn.solver.VariableBase;
import java.util.Map;

public class IfThenElse
implements IExpression {
    public IExpression[] condExpr;
    public IExpression[] thenExpr;
    public IExpression elseExpr;

    public IfThenElse(IExpression condExpr, IExpression thenExpr, IExpression elseExpr) {
        this(new IExpression[]{condExpr}, new IExpression[]{thenExpr}, elseExpr);
    }

    public IfThenElse(IExpression[] condExpr, IExpression[] thenExpr, IExpression elseExpr) {
        this.condExpr = condExpr;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("if ").append(this.condExpr[0]).append(" then ").append(this.thenExpr[0]);
        int i = 1;
        while (i < this.condExpr.length) {
            str.append(" else if ").append(this.condExpr[i]).append(" then ").append(this.thenExpr[i]);
            ++i;
        }
        str.append(" else ").append(this.elseExpr);
        return str.toString();
    }

    @Override
    public Object evaluate(IEnvironment environment) {
        int i = 0;
        while (i < this.condExpr.length) {
            if (((Boolean)this.condExpr[i].evaluate(environment)).booleanValue()) {
                return this.thenExpr[i].evaluate(environment);
            }
            ++i;
        }
        return this.elseExpr.evaluate(environment);
    }

    @Override
    public IExpression withBase(IFrame frame, String prefix) {
        IExpression[] newConds = new IExpression[this.condExpr.length];
        IExpression[] newThens = new IExpression[this.thenExpr.length];
        int i = 0;
        while (i < this.condExpr.length) {
            newConds[i] = this.condExpr[i].withBase(frame, prefix);
            newThens[i] = this.thenExpr[i].withBase(frame, prefix);
            ++i;
        }
        return new IfThenElse(newConds, newThens, this.elseExpr.withBase(frame, prefix));
    }

    @Override
    public Object getPossibleConstant() {
        return null;
    }

    @Override
    public IExpression rewrite(IFrame frame, Map<String, VariableBase> copies) {
        IExpression[] newConds = new IExpression[this.condExpr.length];
        IExpression[] newThens = new IExpression[this.thenExpr.length];
        int i = 0;
        while (i < this.condExpr.length) {
            newConds[i] = this.condExpr[i].rewrite(frame, copies);
            newThens[i] = this.thenExpr[i].rewrite(frame, copies);
            ++i;
        }
        this.condExpr = newConds;
        this.thenExpr = newThens;
        this.elseExpr = this.elseExpr.rewrite(frame, copies);
        return this;
    }

    @Override
    public void accept(IExpression.ExpressionVisitor visitor) {
        visitor.visit(this);
        int i = 0;
        while (i < this.condExpr.length) {
            this.condExpr[i].accept(visitor);
            this.thenExpr[i].accept(visitor);
            ++i;
        }
        this.elseExpr.accept(visitor);
    }
}

