/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
/*
 * 16.8.2006
 */
package org.simantics.utils.datastructures;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * MapList is a data structure with map on left side and arraylist on right side.
 * <p>
 * 
 * @author Toni Kalajainen
 */
public class SynchronizedMapList<L, R> extends MapList<L, R> {



   
    public SynchronizedMapList() {
        super();
    }

    public SynchronizedMapList(MapList<L, R> copyFrom) {
        super(copyFrom);
    }

	public static <L, R> SynchronizedMapList<L, R> use( Map<L, List<R>> map ) {
		SynchronizedMapList<L, R> result = new SynchronizedMapList<L, R>();
		result.lists = map;
		return result;
	}
    
    public synchronized void add(L key) {
        super.add(key);
    }

    public synchronized void add(L key, R value)
    {
        super.add(key, value);
    }

    public synchronized void add(L key, int index, R value)
    {
        super.add(key, index, value);
    }

	public synchronized void addAll(L key, Collection<R> values) {
		super.addAll(key, values);
	}
    

    public synchronized boolean remove(L key, R value)
    {
        return super.remove(key, value);
    }

    public synchronized boolean remove(L key)
    {
        return super.remove(key);
    }

    public synchronized void clear()
    {
        super.clear();
    }

    public synchronized L[] getKeys(L[] list)
    {
        return super.getKeys(list);
    }

    public synchronized Set<L> getKeys()
    {
        return super.getKeys();
    }

    public synchronized int getKeySize() {
        return super.getKeySize();
    }

    public synchronized boolean containsKey(L key)
    {
        return super.containsKey(key);
    }

    public synchronized boolean contains(L key, R obj)
    {
        return super.contains(key, obj);

    }

    public synchronized R[] getValues(L key, R[] list)
    {
        return super.getValues(key, list);
    }

    /**
     * @param key
     *            the key to get values for
     * @param list
     *            the list to fill with existing values for specified key. Fills
     *            this array with at maximum as many values as there is room for
     *            in the array even if there are more values available in the
     *            maplist for the specified key.
     * @return the amount of values existing for the key. May be smaller or
     *         larger than the size of the provided list. If smaller, only the
     *         first array indexes will be filled with data and if larger, all
     *         array indexes will be filled with data.
     */
    public synchronized int getAtMostValues(L key, R[] list)
    {
    	return super.getAtMostValues(key, list);
     }

    /**
     * Returns a the internal list values for the specified key. The list is
     * valid as long as it contains elements. The list should not be modified
     * but the return value of this method does not enforce it like
     * {@link #getValues(Object)} does. Use this method when you know you will
     * not risk a 3rd party modifying the returned list and you want to avoid
     * the cost of extra memory allocation through
     * {@link Collections#unmodifiableList(List)}.
     * 
     * @param key
     *            the key to look values for
     * @return empty unmodifiable list if there is no list with the specified
     *         key, otherwise an unmodifiable version of the stored list
     */
    public synchronized List<R> getValuesUnsafe(L key)
    {
        return super.getValuesUnsafe(key);
    }

    /**
     * Returns a read-only reference to the values. The list is valid as long as
     * it contains elements.
     * 
     * @param key
     * @return empty unmodifiable list if there is no list with the specified key,
     *         otherwise an unmodifiable version of the stored list
     */
    public synchronized List<R> getValues(L key)
    {
        return super.getValues(key);
    }

    /**
     * Returns a copy of the values
     * 
     * @param key
     * @return empty unmodifiable list if there is no list with the specified key,
     *         otherwise a copy of the stored list
     */
    public synchronized List<R> getValuesSnapshot(L key)
    {
        return super.getValuesSnapshot(key);
    }
    
    public synchronized List<R> getAllValuesSnapshot() 
    {
        return super.getAllValuesSnapshot();
    }

    public synchronized List<R> getAllValuesSnapshot(List<R> result) 
    {
    	return getAllValuesSnapshot(result);
    }

    public synchronized boolean isEmpty() {
        return lists.isEmpty();
    }

    /**
     * Makes _this_ maplist immutable.
     */
    @SuppressWarnings("unchecked")
    public synchronized void makeImmutable() {
        super.makeImmutable();
    }

}
