package org.simantics.scl.commands.internal.serialization;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommandMetadata;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.runtime.function.Function2;

public class CommandSerializerImpl implements CommandSerializer {

    String name;
    Function2<Resource,Object,String>[] stringConverters;
    
    CommandSerializerImpl(String name,
            Function2<Resource, Object, String>[] stringConverters) {
        this.name = name;
        this.stringConverters = stringConverters;
    }

    public void serialize(WriteGraph graph, Resource context, Object[] parameters) throws DatabaseException {
        if(parameters.length != stringConverters.length)
            throw new IllegalArgumentException("Wrong number of parameters " + parameters.length + 
                    " given. Expected " + stringConverters.length + " parameters.");
        StringBuilder b = new StringBuilder();
        b.append(name);
        for(int i=0;i<parameters.length;++i)
            b.append(' ').append(stringConverters[i].apply(context, parameters[i]));
        CommandMetadata.add(graph, context.getResourceId(), b.toString());
    }
    
}
