/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.utils;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Transparency;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;

/**
 * @author J-P Laine
 */
public class VRamBufferedImage extends BufferedImage {

    VolatileImage   buffer = null;
    AffineTransform previousTransform = null;

    /**
     * @param original
     * @param imageBounds
     * @param referenceSize a reference size for the rasterized images or
     *        <code>null</code> to not specify one in which case a default
     *        resolution is used
     */
    public VRamBufferedImage(SVGDiagram original, Rectangle2D imageBounds, Point referenceSize) {
        super(original, imageBounds, referenceSize);
    }

    @Override
    public synchronized void releaseRaster() {
        if (buffer != null) {
            buffer.flush();
            buffer = null;
        }
    }

    @Override
    public void paint(Graphics2D g) {
        float margin = 5;

        if(previousTransform == null || previousTransform.getScaleX() != g.getTransform().getScaleX() || previousTransform.getScaleY() != g.getTransform().getScaleY()) {
            buffer = null;
            previousTransform = (AffineTransform)g.getTransform().clone();
            int w = (int)((imageBounds.getWidth()+margin*2) * previousTransform.getScaleX());
            int h = (int)((imageBounds.getHeight()+margin*2) * previousTransform.getScaleY());
            if(w < 1) w = 1;
            if(h < 1) h = 1;
            buffer = g.getDeviceConfiguration().createCompatibleVolatileImage(w, h, Transparency.TRANSLUCENT);

            // FIXME: render in a "while loop" specified in VolatileImage, this is not guaranteed to work.
            try {
                Graphics2D b2g = (Graphics2D)buffer.getGraphics();

                b2g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                b2g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                b2g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);

                b2g.setBackground(new Color(255,255,255,0));
                b2g.clearRect(0, 0, w, h);
                b2g.translate(margin, margin);
                b2g.scale(previousTransform.getScaleX(), previousTransform.getScaleY());
                b2g.translate(-imageBounds.getMinX(), -imageBounds.getMinY());
                source.render(b2g);
            } catch (SVGException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }

        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);

        AffineTransform at = (AffineTransform)g.getTransform().clone();
        try {
            g.translate(imageBounds.getMinX(), imageBounds.getMinY());
            g.scale(1/previousTransform.getScaleX(), 1/previousTransform.getScaleY());
            g.translate(-margin, -margin);

            g.drawImage(buffer, 0, 0, null);
        } finally {
            g.setTransform(at);
        }
    }
}
