package org.simantics.scenegraph.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class SVGPassthruShape implements Shape {

	private String source;
	public final static Font DEFAULT_FONT = Font.decode(null);
	
	public SVGPassthruShape(String source) {
		this.source = source;
	}
	
	public String getSource() {
		return source;
	}
	
	public static void resetG2D(Graphics2D g2d) {
		g2d.setColor(new Color(0, 0, 0));
		g2d.setBackground(new Color(0, 0, 0));
		g2d.setStroke(new BasicStroke());
		g2d.setFont(DEFAULT_FONT);
		QualityHints.HIGH_QUALITY_HINTS.setQuality(g2d);
	}
	
	@Override
	public Rectangle getBounds() {
		return new Rectangle();
	}

	@Override
	public Rectangle2D getBounds2D() {
		return new Rectangle2D.Double();
	}

	@Override
	public boolean contains(double x, double y) {
		return false;
	}

	@Override
	public boolean contains(Point2D p) {
		return false;
	}

	@Override
	public boolean intersects(double x, double y, double w, double h) {
		return false;
	}

	@Override
	public boolean intersects(Rectangle2D r) {
		return false;
	}

	@Override
	public boolean contains(double x, double y, double w, double h) {
		return false;
	}

	@Override
	public boolean contains(Rectangle2D r) {
		return false;
	}

	@Override
	public PathIterator getPathIterator(AffineTransform at) {
		return new EmptyPathIterator();
	}
	
	@Override
	public PathIterator getPathIterator(AffineTransform at, double flatness) {
		return new EmptyPathIterator();
	}

	private class EmptyPathIterator implements PathIterator {
		
		@Override
		public void next() {
			
		}
		
		@Override
		public boolean isDone() {
			return true;
		}
		
		@Override
		public int getWindingRule() {
			return 0;
		}
		
		@Override
		public int currentSegment(double[] coords) {
			return 0;
		}
		
		@Override
		public int currentSegment(float[] coords) {
			return 0;
		}
	};

}
