package org.simantics.scenegraph.g2d.nodes;

/**
 * @author Antti Villberg
 * @since 1.29.0
 */
public class SVGNodeAssignment {
	public String elementId;
	public String attributeNameOrId;
	public String value;
	public SVGNodeAssignment(String elementId, String attributeNameOrId, String value) {
		this.elementId = elementId;
		this.attributeNameOrId = attributeNameOrId;
		this.value = value;
	}
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((attributeNameOrId == null) ? 0 : attributeNameOrId.hashCode());
		result = prime * result + ((elementId == null) ? 0 : elementId.hashCode());
		result = prime * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SVGNodeAssignment other = (SVGNodeAssignment) obj;
		if (attributeNameOrId == null) {
			if (other.attributeNameOrId != null)
				return false;
		} else if (!attributeNameOrId.equals(other.attributeNameOrId))
			return false;
		if (elementId == null) {
			if (other.elementId != null)
				return false;
		} else if (!elementId.equals(other.elementId))
			return false;
		if (value == null) {
			if (other.value != null)
				return false;
		} else if (!value.equals(other.value))
			return false;
		return true;
	}
	@Override
	public String toString() {
		return "SVGNodeAssignment eid=" + elementId + " attributeNameOrId=" + attributeNameOrId + " value=" + value;
	}
}