/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.events;

/**
 * @author Toni Kalajainen
 */
public abstract class FocusEvent extends Event {

    private static final long serialVersionUID = 1499461937927925764L;

    FocusEvent(Object context, long time) {
        super(context, time);
    }

    public static class FocusGainedEvent extends FocusEvent {
        private static final long serialVersionUID = 64824708700106984L;
        public FocusGainedEvent(Object context, long time) {
            super(context, time);
        }
        @Override
        public String toString() {
            return "Focus Gained";
        }
    }

    public static class FocusLostEvent extends FocusEvent {
        private static final long serialVersionUID = -3015854169051963725L;
        public FocusLostEvent(Object context, long time) {
            super(context, time);
        }
        @Override
        public String toString() {
            return "Focus Lost";
        }
    }

}

