/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.issues.common;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;

/*
 * This request computes all available continuous issue sources for a model.
 * 
 */
public class ContinuousIssueSources extends ResourceRead<Collection<Resource>> {

    public ContinuousIssueSources(Resource model) {
        super(model);
    }

    @Override
    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {

        Layer0 b = Layer0.getInstance(graph);
        IssueResource ISSUE = IssueResource.getInstance(graph);

        return graph.syncRequest(new ObjectsWithType(resource, b.ConsistsOf, ISSUE.ContinuousIssueSource));

    }

}
