package org.simantics.document.server.request;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.UnaryAsyncRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableChildren;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public class NodesRequest extends VariableRead<Set<Variable>> {

    public NodesRequest(Variable var) {
        super(var);
    }

    static class CollectNodesRequest2 extends UnaryAsyncRead<Collection<Variable>, Set<Variable>> {

        public CollectNodesRequest2(Collection<Variable> nodes) {
            super(nodes);
        }

        @Override
        public void perform(AsyncReadGraph graph, AsyncProcedure<Set<Variable>> procedure) {
            HashSet<Variable> rs = new HashSet<Variable>(); // result

            for(Variable node : parameter) {
                graph.asyncRequest(new NodesRequest2(node), new AsyncProcedure<Set<Variable>> () {

                    @Override
                    public void execute(AsyncReadGraph graph, Set<Variable> result) {
                        synchronized(rs) {
                            rs.addAll(result);
                        }
                    }

                    @Override
                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                    }

                });

            }
            procedure.execute(graph, rs);

        }

    }

    @Override
    public Set<Variable> perform(ReadGraph graph) throws DatabaseException {

        ITask task = DocumentRequest.PROFILE ? ThreadLogger.task(this) : null;

        StructuralResource2.getInstance(graph);
        if(variable == null)
            return Collections.emptySet();

        Collection<Variable> children = graph.syncRequest(new VariableChildren(variable));

        Set<Variable> nodes = graph.syncRequest(new CollectNodesRequest2(children));

        if(DocumentRequest.PROFILE) task.finish();

        return nodes;

    }

}