package org.simantics.document.server.request;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.document.server.DocumentServerUtils;
import org.simantics.document.server.JSONObject;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;

/**
 * @author Antti Villberg
 * @since 1.30.0
 */
public class DefaultFields extends VariableRead<JSONObject> {

    public DefaultFields(Variable variable) {
        super(variable);
    }

    @Override
    public JSONObject perform(ReadGraph graph) throws DatabaseException {

        Layer0 L0 = Layer0.getInstance(graph);
        StructuralResource2.getInstance(graph);
        DocumentationResource DOC = DocumentationResource.getInstance(graph);

        String id = DocumentServerUtils.getId(graph, variable);

        Binding jsonBinding = graph.getService(Databoard.class).getBindingUnchecked(JSONObject.class);
        JSONObject object = new JSONObject(jsonBinding, id);

        Resource type = variable.getType(graph);

        Variable parentConnectionPoint = DocumentServerUtils.getParentConnectionPoint(graph, variable);
        while (parentConnectionPoint != null) {
            Variable par = parentConnectionPoint.getParent(graph);
            if(!DOC.Components_DummyContainer.equals(par.getType(graph))) break;
            parentConnectionPoint = DocumentServerUtils.getParentConnectionPoint(graph, par);
        }

        if(parentConnectionPoint != null) {
            String parent = DocumentServerUtils.getId(graph, parentConnectionPoint.getParent(graph));
            Resource cpPredicate = parentConnectionPoint.getPossiblePredicateResource(graph);
            String i = null;
            if (DOC.Relations_partN.equals(cpPredicate)) {
                i = DocumentServerUtils.findManualOrdinal(graph, variable);
            } else {
                i = graph.getPossibleRelatedValue(cpPredicate, DOC.Document_ChildRelation_ordinal, Bindings.STRING);
            }
            if (i == null) {
                i = "0";
            }

            object.addJSONField("parent", parent);
            object.addJSONField("parentOrd", i);
        } else {
            if(DOC.Components_Root.equals(type) || graph.isInheritedFrom(type, DOC.Components_Root)) {
                object.addJSONField("parent", "root");
                object.addJSONField("parentOrd", "0");
            } if(!graph.isInheritedFrom(type, DOC.Components_ParentlessComponent)) {
                object.addJSONField("parent", "");
                object.addJSONField("parentOrd", "0");
            }
        }

        object.addJSONField("id", id);
        object.addJSONField("type", graph.<String>getRelatedValue(type, L0.HasName, Bindings.STRING));
        return object;

    }

}