/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.synchronization.graph;

import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.synchronization.ModificationAdapter;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;

public class RelatedPropertyModification
extends ModificationAdapter {
    private final Resource subject;
    private final Resource relation;
    private final Resource propertyRelation;
    private final Resource type;
    private final Object value;
    private final Binding binding;

    public RelatedPropertyModification(Resource subject, Resource relation, Resource propertyRelation, Resource propertyType, Object value, Binding binding) {
        super(LOW_PRIORITY);
        this.subject = subject;
        this.relation = relation;
        this.propertyRelation = propertyRelation;
        this.type = propertyType;
        this.value = value;
        this.binding = binding;
    }

    @Override
    public void perform(WriteGraph g) throws DatabaseException {
        Object existing;
        Resource propertyOwner = g.getPossibleObject(this.subject, this.relation);
        if (propertyOwner != null && !this.value.equals(existing = g.getPossibleRelatedValue(propertyOwner, this.propertyRelation, this.binding))) {
            g.markUndoPoint();
            DiagramGraphUtil.setRelatedValue(g, propertyOwner, this.propertyRelation, this.type, this.value, this.binding);
            CommentMetadata cm = (CommentMetadata)g.getMetadata(CommentMetadata.class);
            g.addMetadata((Metadata)cm.add("Changed property " + NameUtils.getSafeLabel((ReadGraph)g, (Resource)this.propertyRelation) + " in " + NameUtils.getSafeName((ReadGraph)g, (Resource)propertyOwner)));
        }
    }
}

