package org.simantics.datatypes.utils;

import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.datatypes.DatatypeResource;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.runtime.tuple.Tuple2;

public class BTree {
	
	final private BTreeUtils utils;
	
	public BTree(WriteGraph graph, int t, Resource ownerRelation) throws DatabaseException {
		this(graph, t, ownerRelation, false);
	}
	
	public BTree(WriteGraph graph, int t, Resource ownerRelation, boolean cached) throws DatabaseException {
		utils = BTreeUtils.create(graph, ownerRelation, t, cached);
	}
	
	public BTree(WriteGraph graph, int t, Resource type, Resource nodeType, Resource ownerRelation, boolean cached) throws DatabaseException {
		utils = BTreeUtils.create(graph, type, nodeType, ownerRelation, t, cached);
	}

	public BTree(ReadGraph graph, Resource tree) throws DatabaseException {
		this(graph, tree, false);
	}
	
	public BTree(ReadGraph graph, Resource tree, boolean cached) throws DatabaseException {
		DatatypeResource DATA = DatatypeResource.getInstance(graph);
		int t = graph.getRelatedValue(tree, DATA.BTree_t, Bindings.INTEGER);
		Resource ownerRelation = graph.getPossibleObject(tree, DATA.BTree_HasOwnerRelation);
		Resource nodeType = graph.getPossibleObject(tree, DATA.BTree_HasNodeType);
		utils = new BTreeUtils(graph, tree, t, nodeType, ownerRelation, cached);
	}
	
	public void flushCachedBTree(WriteGraph graph) throws DatabaseException {
		utils.flushCache(graph);
	}
	
	public Resource rootOfBTree() {
		return utils.getTree();
	}
	
	public void insertBTree(WriteGraph graph, Variant key, Resource value) throws DatabaseException {
		utils.insert(graph, key, value);
	}
	
	public Resource searchBTree(ReadGraph graph, Variant key) throws DatabaseException {
		return utils.search(graph, key);
	}

	public void removeBTree(WriteGraph graph, Variant key) throws DatabaseException {
		utils.remove(graph, key);
	}
	
	public List<Tuple2> entriesOfBTree(ReadGraph graph) throws DatabaseException {
		return utils.entries(graph);
	}
	
	public List<Tuple2> searchRangeBTree(ReadGraph graph, Variant min, Variant max) throws DatabaseException {
		return utils.searchRange(graph, min, max);
	}
}
