/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.content;

import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.LabelDecoratorKey;


/**
 * An interface for constructing decorators for controlling the aesthetic
 * properties of an UI item, including the label text, font, background color
 * and foreground color.
 * 
 * @author Tuukka Lehtonen
 */
public interface LabelDecoratorFactory {

    /**
     * @param manager the manager for performing more queries to decide how to
     *        decorate the label of the specified input
     * @param context the input node context to evaluate for decoration
     * @return <code>null</code> if no decoration is desired for the specified
     *         input
     */
    LabelDecorator create(PrimitiveQueryUpdater manager, NodeContext context, LabelDecoratorKey key);

}
