/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui;

import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;
import org.simantics.browsing.ui.NodeContext.QueryKey;
import org.simantics.browsing.ui.exception.NoQueryProcessorException;

/**
 * These methods may only be called from the UI thread of the GraphExplorer in
 * use.
 * 
 * @see {@link GraphExplorer#getThread()}
 */
public interface NodeQueryManager {
    <T> T query(NodeContext context, QueryKey<T> key) throws NoQueryProcessorException;
    <T> T query(NodeContext context, PrimitiveQueryKey<T> key) throws NoQueryProcessorException;
}
