/*******************************************************************************
 * Copyright (c) 2010, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.model.sorters;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.InvalidContribution;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.browsing.ui.model.visuals.VisualsContribution;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class SorterContribution extends VisualsContribution {
    SorterRule modifierRule;
    
    public SorterContribution(NodeType nodeType, Test test, SorterRule modifierRule, double priority) throws InvalidContribution {
        super(nodeType, test, priority);
        if(!modifierRule.isCompatible(
                nodeType.getContentType()
                ))
            throw new InvalidContribution("Sorter rule is not compatible with the content type.");
        this.modifierRule = modifierRule;
    }
       
    public Sorter getSorter(ReadGraph graph, NodeContext context) {
        Object content = context.getConstant(BuiltinKeys.INPUT);
        try {
            if(test == null || test.test(graph, content))            
                return modifierRule.getSorter(graph, content);
            else
                return null;
        } catch(DatabaseException e) {
            // TODO reconsider
            return null;
        }
    }    
}
