/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.koloboke.collect.map.hash;

import com.koloboke.collect.*;
import com.koloboke.collect.hash.*;
import com.koloboke.compile.CustomKeyEquivalence;
import com.koloboke.compile.KolobokeMap;
import java.util.function.Consumer;
import com.koloboke.collect.map.*;

import javax.annotation.Nonnull;

import java.util.Map;



/**
 * An immutable factory of {@code HashIntLongMap}s.
 *
 * @see HashIntLongMap
 * @see HashIntLongMaps#getDefaultFactory()
 * @see KolobokeMap @KolobokeMap
 */
public interface HashIntLongMapFactory
        extends IntLongMapFactory<HashIntLongMapFactory>
        , IntHashFactory<HashIntLongMapFactory>
        {


    

    

    

    

    

    
    

    
    


    @Override
    @Nonnull
     HashIntLongMap newMutableMap();

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashIntLongMap newMutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3,
            @Nonnull Map<Integer, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3,
            @Nonnull Map<Integer, Long> map4,
            @Nonnull Map<Integer, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntLongMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.IntLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(
            @Nonnull int[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(
            @Nonnull Integer[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(
            @Nonnull Map<Integer, Long> map);

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2);

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3);

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3,
            @Nonnull Map<Integer, Long> map4);

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3,
            @Nonnull Map<Integer, Long> map4,
            @Nonnull Map<Integer, Long> map5);



    @Override
    @Nonnull
     HashIntLongMap newMutableMap(@Nonnull
            Consumer<com.koloboke.function.IntLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(
            @Nonnull int[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(
            @Nonnull Integer[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashIntLongMap newMutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashIntLongMap newMutableMapOf(int k1, long v1);

    @Override
    @Nonnull
     HashIntLongMap newMutableMapOf(int k1, long v1,
            int k2, long v2);

    @Override
    @Nonnull
     HashIntLongMap newMutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3);

    @Override
    @Nonnull
     HashIntLongMap newMutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4);

    @Override
    @Nonnull
     HashIntLongMap newMutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4, int k5, long v5);
    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap();

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(int expectedSize);

    


    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3,
            @Nonnull Map<Integer, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3,
            @Nonnull Map<Integer, Long> map4,
            @Nonnull Map<Integer, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.IntLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(
            @Nonnull int[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(
            @Nonnull Integer[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(
            @Nonnull Map<Integer, Long> map);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3,
            @Nonnull Map<Integer, Long> map4);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3,
            @Nonnull Map<Integer, Long> map4,
            @Nonnull Map<Integer, Long> map5);



    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(@Nonnull
            Consumer<com.koloboke.function.IntLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(
            @Nonnull int[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(
            @Nonnull Integer[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashIntLongMap newUpdatableMapOf(int k1, long v1);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMapOf(int k1, long v1,
            int k2, long v2);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4);

    @Override
    @Nonnull
     HashIntLongMap newUpdatableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4, int k5, long v5);

    


    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3,
            @Nonnull Map<Integer, Long> map4, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3,
            @Nonnull Map<Integer, Long> map4,
            @Nonnull Map<Integer, Long> map5, int expectedSize);



    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.IntLongConsumer> entriesSupplier
            , int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(
            @Nonnull int[] keys, @Nonnull long[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(
            @Nonnull Integer[] keys, @Nonnull Long[] values, int expectedSize);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Long> values, int expectedSize);

    

    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(
            @Nonnull Map<Integer, Long> map);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3,
            @Nonnull Map<Integer, Long> map4);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(@Nonnull Map<Integer, Long> map1,
            @Nonnull Map<Integer, Long> map2,
            @Nonnull Map<Integer, Long> map3,
            @Nonnull Map<Integer, Long> map4,
            @Nonnull Map<Integer, Long> map5);



    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(@Nonnull
            Consumer<com.koloboke.function.IntLongConsumer> entriesSupplier
            );

    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(
            @Nonnull int[] keys, @Nonnull long[] values);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(
            @Nonnull Integer[] keys, @Nonnull Long[] values);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMap(@Nonnull Iterable<Integer> keys,
            @Nonnull Iterable<Long> values);


    @Override
    @Nonnull
     HashIntLongMap newImmutableMapOf(int k1, long v1);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMapOf(int k1, long v1,
            int k2, long v2);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4);

    @Override
    @Nonnull
     HashIntLongMap newImmutableMapOf(int k1, long v1,
            int k2, long v2, int k3, long v3,
            int k4, long v4, int k5, long v5);
}
