/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.client.write;

import com.influxdb.Arguments;
import com.influxdb.client.domain.WritePrecision;
import com.influxdb.client.write.PointSettings;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class Point {
    private static final WritePrecision DEFAULT_WRITE_PRECISION = WritePrecision.NS;
    private static final int MAX_FRACTION_DIGITS = 340;
    private static final ThreadLocal<NumberFormat> NUMBER_FORMATTER = ThreadLocal.withInitial(() -> {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.ENGLISH);
        numberFormat.setMaximumFractionDigits(340);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(1);
        return numberFormat;
    });
    private String name;
    private final Map<String, String> tags = new TreeMap<String, String>();
    private final Map<String, Object> fields = new TreeMap<String, Object>();
    private Long time;
    private WritePrecision precision = DEFAULT_WRITE_PRECISION;

    @Nonnull
    public static Point measurement(@Nonnull String measurementName) {
        Arguments.checkNotNull((Object)measurementName, (String)"measurement");
        Point point = new Point();
        point.name = measurementName;
        return point;
    }

    @Nonnull
    public Point addTag(@Nonnull String key, @Nullable String value) {
        Arguments.checkNotNull((Object)key, (String)"tagName");
        this.tags.put(key, value);
        return this;
    }

    @Nonnull
    public Point addField(@Nonnull String field, boolean value) {
        return this.putField(field, value);
    }

    public Point addField(@Nonnull String field, long value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point addField(@Nonnull String field, double value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point addField(@Nonnull String field, @Nullable Number value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point addField(@Nonnull String field, @Nullable String value) {
        return this.putField(field, value);
    }

    @Nonnull
    public Point time(@Nullable Instant time, @Nonnull WritePrecision precision) {
        long longTime;
        if (time == null) {
            return this.time((Long)null, precision);
        }
        Duration plus = Duration.ofNanos(time.getNano()).plus(time.getEpochSecond(), ChronoUnit.SECONDS);
        switch (precision) {
            case NS: {
                longTime = TimeUnit.NANOSECONDS.convert(plus.toNanos(), TimeUnit.NANOSECONDS);
                break;
            }
            case US: {
                longTime = TimeUnit.MICROSECONDS.convert(plus.toNanos(), TimeUnit.NANOSECONDS);
                break;
            }
            case MS: {
                longTime = TimeUnit.MILLISECONDS.convert(plus.toNanos(), TimeUnit.NANOSECONDS);
                break;
            }
            case S: {
                longTime = TimeUnit.SECONDS.convert(plus.toNanos(), TimeUnit.NANOSECONDS);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported precision: " + (Object)((Object)precision));
            }
        }
        return this.time(longTime, precision);
    }

    @Nonnull
    public Point time(@Nullable Long time, @Nonnull WritePrecision precision) {
        this.time = time;
        this.precision = precision;
        return this;
    }

    @Nonnull
    public WritePrecision getPrecision() {
        return this.precision;
    }

    public boolean hasFields() {
        return !this.fields.isEmpty();
    }

    @Nonnull
    public String toLineProtocol() {
        return this.toLineProtocol(null);
    }

    @Nonnull
    public String toLineProtocol(@Nullable PointSettings pointSettings) {
        StringBuilder sb = new StringBuilder();
        this.escapeKey(sb, this.name);
        this.appendTags(sb, pointSettings);
        boolean appendedFields = this.appendFields(sb);
        if (!appendedFields) {
            return "";
        }
        this.appendTime(sb);
        return sb.toString();
    }

    @Nonnull
    private Point putField(@Nonnull String field, @Nullable Object value) {
        Arguments.checkNonEmpty((String)field, (String)"fieldName");
        this.fields.put(field, value);
        return this;
    }

    private void appendTags(@Nonnull StringBuilder sb, @Nullable PointSettings pointSettings) {
        Map<String, String> defaultTags;
        Set<Map.Entry<String, String>> entries = this.tags.entrySet();
        if (pointSettings != null && !(defaultTags = pointSettings.getDefaultTags()).isEmpty()) {
            entries = Stream.of(this.tags, defaultTags).map(Map::entrySet).flatMap(Collection::stream).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> {
                if (v1.isEmpty()) {
                    return v2;
                }
                return v1;
            }, TreeMap::new)).entrySet();
        }
        for (Map.Entry<String, String> tag : entries) {
            String key = tag.getKey();
            String value = tag.getValue();
            if (key.isEmpty() || value.isEmpty()) continue;
            sb.append(',');
            this.escapeKey(sb, key);
            sb.append('=');
            this.escapeKey(sb, value);
        }
        sb.append(' ');
    }

    private boolean appendFields(@Nonnull StringBuilder sb) {
        boolean appended = false;
        for (Map.Entry<String, Object> field : this.fields.entrySet()) {
            Object value = field.getValue();
            if (this.isNotDefined(value)) continue;
            this.escapeKey(sb, field.getKey());
            sb.append('=');
            if (value instanceof Number) {
                if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
                    sb.append(NUMBER_FORMATTER.get().format(value));
                } else {
                    sb.append(value).append('i');
                }
            } else if (value instanceof String) {
                String stringValue = (String)value;
                sb.append('\"');
                this.escapeValue(sb, stringValue);
                sb.append('\"');
            } else {
                sb.append(value);
            }
            sb.append(',');
            appended = true;
        }
        int lengthMinusOne = sb.length() - 1;
        if (sb.charAt(lengthMinusOne) == ',') {
            sb.setLength(lengthMinusOne);
        }
        return appended;
    }

    private void appendTime(@Nonnull StringBuilder sb) {
        if (this.time == null) {
            return;
        }
        sb.append(" ").append(this.time);
    }

    private void escapeKey(@Nonnull StringBuilder sb, @Nonnull String key) {
        for (int i = 0; i < key.length(); ++i) {
            switch (key.charAt(i)) {
                case ' ': 
                case ',': 
                case '=': {
                    sb.append('\\');
                }
            }
            sb.append(key.charAt(i));
        }
    }

    private void escapeValue(@Nonnull StringBuilder sb, @Nonnull String value) {
        for (int i = 0; i < value.length(); ++i) {
            switch (value.charAt(i)) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                }
            }
            sb.append(value.charAt(i));
        }
    }

    private boolean isNotDefined(Object value) {
        return value == null || value instanceof Double && !Double.isFinite((Double)value) || value instanceof Float && !Float.isFinite(((Float)value).floatValue());
    }
}

